/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven;

public final class SvnSection {
    public static final String UNKNOWN = "unknown";
    public static final String BOOTSTRAP = "bootstrap";
    public static final String STABLE = "stable";
    public static final String COOKING = "cooking";
    public static final String PROD = "prod";
    public static final String EXPERIMENTAL = "experimental";

    private SvnSection() {
    }

    public static String fromString(String sectionName) {
        if (sectionName == null) {
            return UNKNOWN;
        }
        if (sectionName.equals(BOOTSTRAP)) {
            return BOOTSTRAP;
        }
        if (sectionName.equals(STABLE)) {
            return STABLE;
        }
        if (sectionName.equals(COOKING)) {
            return COOKING;
        }
        if (sectionName.equals(PROD)) {
            return PROD;
        }
        if (sectionName.equals(EXPERIMENTAL)) {
            return EXPERIMENTAL;
        }
        return UNKNOWN;
    }

    public static boolean canDependOn(String op1, String op2) {
        if (UNKNOWN.equals(op1)) {
            return true;
        }
        if (BOOTSTRAP.equals(op1)) {
            return UNKNOWN.equals(op2) || BOOTSTRAP.equals(op2);
        }
        if (STABLE.equals(op1)) {
            return UNKNOWN.equals(op2) || BOOTSTRAP.equals(op2) || STABLE.equals(op2);
        }
        if (COOKING.equals(op1)) {
            return UNKNOWN.equals(op2) || BOOTSTRAP.equals(op2) || STABLE.equals(op2) || COOKING.equals(op2);
        }
        if (PROD.equals(op1)) {
            return UNKNOWN.equals(op2) || BOOTSTRAP.equals(op2) || STABLE.equals(op2) || COOKING.equals(op2) || PROD.equals(op2);
        }
        if (EXPERIMENTAL.equals(op1)) {
            return UNKNOWN.equals(op2) || BOOTSTRAP.equals(op2) || STABLE.equals(op2) || COOKING.equals(op2) || PROD.equals(op2) || EXPERIMENTAL.equals(op2);
        }
        throw new RuntimeException(String.format("Unknown section '%s'", op1));
    }
}

