/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven.enforcerrules;

import com.ebmwebsourcing.tools.maven.ProjectHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

abstract class AbstractRule
implements EnforcerRule {
    private boolean mustFail = true;
    public static final String PETALSLINK_SNAPSHOT_REPO = "http://maven.petalslink.com/public-snapshot";
    public static final String PETALSLINK_ARTIFACTORY_SNAPSHOT_REPO = "http://m2proxy:8081/artifactory/libs-snapshot-local";

    AbstractRule() {
    }

    protected final boolean isPetalsLinkProject(MavenProject project) {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        return ProjectHelper.isPetalsLinkProject(groupId, artifactId);
    }

    protected final boolean isEbmWebsourcingProject(MavenProject project) {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        return this.isEbmWebsourcingProject(groupId, artifactId);
    }

    protected final boolean isEbmWebsourcingProject(String groupId, String artifactId) {
        return groupId.equals("com.ebmwebsourcing") && artifactId.equals("ebmwebsourcing");
    }

    protected final boolean isJbiSharedLibraryProject(MavenProject project) {
        String packaging = project.getPackaging();
        return packaging != null && packaging.equals("jbi-shared-library");
    }

    protected final MavenProject findMavenProjectForDependency(EnforcerRuleHelper helper, MavenProject parentProject, Dependency dependency) throws EnforcerRuleException, ExpressionEvaluationException, ComponentLookupException {
        ArtifactRepository localRepository = (ArtifactRepository)helper.evaluate("${localRepository}");
        ArtifactFactory artifactFactory = (ArtifactFactory)helper.getComponent(ArtifactFactory.class);
        Artifact pomArtifact = artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType());
        try {
            MavenProjectBuilder mpb = (MavenProjectBuilder)helper.getComponent(MavenProjectBuilder.class);
            MavenProject dependencyMavenProject = mpb.buildFromRepository(pomArtifact, parentProject.getRemoteArtifactRepositories(), localRepository);
            return dependencyMavenProject;
        }
        catch (Exception e) {
            throw new EnforcerRuleException("Cannot create dependency MavenProject.", e);
        }
    }

    protected abstract void doExecute(EnforcerRuleHelper var1) throws Exception;

    public final void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            log.info((CharSequence)String.format("Checking enforcer rule %s.", this.getClass().getSimpleName()));
            this.doExecute(helper);
        }
        catch (EnforcerRuleException e) {
            if (this.mustFail) {
                throw e;
            }
            log.warn((CharSequence)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new EnforcerRuleException("Unexpected problem." + e.getLocalizedMessage(), e);
        }
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule arg0) {
        return false;
    }
}

