/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven.enforcerrules;

import com.ebmwebsourcing.tools.maven.enforcerrules.AbstractRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;

public class NoDependencyVersionOverride
extends AbstractRule {
    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject)helper.evaluate("${project}");
        if (!this.isJbiSharedLibraryProject(mavenProject)) {
            HashMap<MavenProject, List<Dependency>> parentDependenciesByParentProject = NoDependencyVersionOverride.getAllParentDepFromDepMgtByProject(mavenProject);
            List<Dependency> dependencies = NoDependencyVersionOverride.getNewDependencies(mavenProject);
            for (Dependency dependency : dependencies) {
                String depGroupId = dependency.getGroupId();
                String depArtifactId = dependency.getArtifactId();
                String depVersion = dependency.getVersion();
                for (MavenProject parentProject : parentDependenciesByParentProject.keySet()) {
                    List<Dependency> parentDependencies = parentDependenciesByParentProject.get(parentProject);
                    for (Dependency parentDependency : parentDependencies) {
                        String parentDepGroupId = parentDependency.getGroupId();
                        String parentDepArtifactId = parentDependency.getArtifactId();
                        String parentDepVersion = parentDependency.getVersion();
                        if (!depGroupId.equals(parentDepGroupId) || !depArtifactId.equals(parentDepArtifactId) || depVersion.equals(parentDepVersion)) continue;
                        String parentGroupId = parentProject.getGroupId();
                        String parentArtifactId = parentProject.getArtifactId();
                        String message = String.format("The dependency %s:%s:%s override is not allowed : dependency %s:%s:%s is defined in the dependencyManagement section of the ancestor project %s:%s.", depGroupId, depArtifactId, depVersion, parentDepGroupId, parentDepArtifactId, parentDepVersion, parentGroupId, parentArtifactId);
                        throw new EnforcerRuleException(message);
                    }
                }
            }
        }
    }

    private static final List<Dependency> getNewDependencies(MavenProject mavenProject) {
        List<String> allParentDepId = NoDependencyVersionOverride.getAllParentDep(mavenProject);
        List allDep = mavenProject.getDependencies();
        return NoDependencyVersionOverride.getNewDep(allParentDepId, allDep);
    }

    private static final List<String> getAllParentDep(MavenProject mavenProject) {
        MavenProject parentProject = mavenProject.getParent();
        ArrayList<String> allParentDepId = new ArrayList<String>();
        if (parentProject != null) {
            List allParentDep = parentProject.getDependencies();
            for (Dependency dependency : allParentDep) {
                String groupId = dependency.getGroupId();
                String artifactId = dependency.getArtifactId();
                String version = dependency.getVersion();
                String depParId = groupId + ":" + artifactId + ":" + version;
                allParentDepId.add(depParId);
            }
        }
        return allParentDepId;
    }

    private static final HashMap<MavenProject, List<Dependency>> getAllParentDepFromDepMgtByProject(MavenProject mavenProject) {
        return NoDependencyVersionOverride.getAllParentDepFromDepMgtByProject(mavenProject, new ArrayList<String>());
    }

    private static final HashMap<MavenProject, List<Dependency>> getAllParentDepFromDepMgtByProject(MavenProject mavenProject, List<String> allParentDepFromDepMgt) {
        HashMap<MavenProject, List<Dependency>> parentDepFromDepMgt = new HashMap<MavenProject, List<Dependency>>();
        if (mavenProject.hasParent()) {
            MavenProject parentProject = mavenProject.getParent();
            parentDepFromDepMgt.putAll(NoDependencyVersionOverride.getAllParentDepFromDepMgtByProject(parentProject, allParentDepFromDepMgt));
            DependencyManagement dependencyManagement = parentProject.getDependencyManagement();
            if (dependencyManagement != null) {
                List allDep = dependencyManagement.getDependencies();
                List<Dependency> newDep = NoDependencyVersionOverride.getNewDep(allParentDepFromDepMgt, allDep);
                parentDepFromDepMgt.put(parentProject, newDep);
            }
        }
        return parentDepFromDepMgt;
    }

    private static final List<Dependency> getNewDep(List<String> allParentDepId, List<Dependency> allDep) {
        ArrayList<Dependency> newDep = new ArrayList<Dependency>();
        for (Dependency dependency : allDep) {
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            String version = dependency.getVersion();
            String depParId = groupId + ":" + artifactId + ":" + version;
            if (allParentDepId.contains(depParId)) continue;
            newDep.add(dependency);
            allParentDepId.add(depParId);
        }
        return newDep;
    }
}

