/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven.enforcerrules;

import com.ebmwebsourcing.tools.maven.enforcerrules.AbstractRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.project.MavenProject;

public class NoPluginVersionOverride
extends AbstractRule {
    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject)helper.evaluate("${project}");
        HashMap<MavenProject, List<Plugin>> parentPluginsByParentProject = NoPluginVersionOverride.getAllParentPluginsFromPluginMgtByProject(mavenProject);
        List<Plugin> plugins = NoPluginVersionOverride.getNewPlugins(mavenProject);
        for (Plugin plugin : plugins) {
            for (MavenProject parentProject : parentPluginsByParentProject.keySet()) {
                List<Plugin> parentPlugins = parentPluginsByParentProject.get(parentProject);
                for (Plugin parentPlugin : parentPlugins) {
                    if (!NoPluginVersionOverride.isOverridingPluginVersion(parentPlugin, plugin)) continue;
                    String parentGroupId = parentProject.getGroupId();
                    String parentArtifactId = parentProject.getArtifactId();
                    String message = String.format("The plugin %s:%s:%s override is not allowed : plugin %s:%s:%s is defined in the pluginManagement section of the ancestor project %s:%s.", plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), parentPlugin.getGroupId(), parentPlugin.getArtifactId(), parentPlugin.getVersion(), parentGroupId, parentArtifactId);
                    throw new EnforcerRuleException(message);
                }
            }
        }
    }

    private static boolean isOverridingPluginVersion(Plugin parentPlugin, Plugin plugin) {
        String parentPluginGroupId = parentPlugin.getGroupId();
        String parentPluginArtifactId = parentPlugin.getArtifactId();
        String parentPluginVersion = parentPlugin.getVersion();
        String pluginGroupId = plugin.getGroupId();
        String pluginArtifactId = plugin.getArtifactId();
        String pluginVersion = plugin.getVersion();
        if (pluginGroupId.equals(parentPluginGroupId) && pluginArtifactId.equals(parentPluginArtifactId)) {
            if (pluginVersion == null) {
                return false;
            }
            return !pluginVersion.equals(parentPluginVersion);
        }
        return false;
    }

    private static final List<Plugin> getNewPlugins(MavenProject mavenProject) {
        List<String> allParentPluginId = NoPluginVersionOverride.getAllParentPlugins(mavenProject);
        List allPlugins = mavenProject.getBuildPlugins();
        return NoPluginVersionOverride.getNewPlugin(allParentPluginId, allPlugins);
    }

    private static final List<String> getAllParentPlugins(MavenProject mavenProject) {
        MavenProject parentProject = mavenProject.getParent();
        ArrayList<String> allParentDepId = new ArrayList<String>();
        if (parentProject != null) {
            List allParentPlugins = parentProject.getBuildPlugins();
            for (Plugin plugin : allParentPlugins) {
                String groupId = plugin.getGroupId();
                String artifactId = plugin.getArtifactId();
                String version = plugin.getVersion();
                String depParId = groupId + ":" + artifactId + ":" + version;
                allParentDepId.add(depParId);
            }
        }
        return allParentDepId;
    }

    private static final HashMap<MavenProject, List<Plugin>> getAllParentPluginsFromPluginMgtByProject(MavenProject mavenProject) {
        return NoPluginVersionOverride.getAllParentPluginsFromPluginMgtByProject(mavenProject, new ArrayList<String>());
    }

    private static final HashMap<MavenProject, List<Plugin>> getAllParentPluginsFromPluginMgtByProject(MavenProject mavenProject, List<String> allParentDepFromDepMgt) {
        HashMap<MavenProject, List<Plugin>> parentPluginFromPluginMgt = new HashMap<MavenProject, List<Plugin>>();
        if (mavenProject.hasParent()) {
            MavenProject parentProject = mavenProject.getParent();
            parentPluginFromPluginMgt.putAll(NoPluginVersionOverride.getAllParentPluginsFromPluginMgtByProject(parentProject, allParentDepFromDepMgt));
            PluginManagement pluginManagement = parentProject.getPluginManagement();
            if (pluginManagement != null) {
                List allPlugins = pluginManagement.getPlugins();
                List<Plugin> newDep = NoPluginVersionOverride.getNewPlugin(allParentDepFromDepMgt, allPlugins);
                parentPluginFromPluginMgt.put(parentProject, newDep);
            }
        }
        return parentPluginFromPluginMgt;
    }

    private static final List<Plugin> getNewPlugin(List<String> allParentPluginId, List<Plugin> allPlugins) {
        ArrayList<Plugin> newPlugins = new ArrayList<Plugin>();
        for (Plugin plugin : allPlugins) {
            String groupId = plugin.getGroupId();
            String artifactId = plugin.getArtifactId();
            String version = plugin.getVersion();
            String depParId = groupId + ":" + artifactId + ":" + version;
            if (allParentPluginId.contains(depParId)) continue;
            newPlugins.add(plugin);
            allParentPluginId.add(depParId);
        }
        return newPlugins;
    }
}

