/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven.enforcerrules;

import com.ebmwebsourcing.tools.maven.enforcerrules.AbstractRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;

public class OneAndOnlyOnePluginVersionInEbmWebsourcingPluginManagement
extends AbstractRule {
    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject)helper.evaluate("${project}");
        if (mavenProject.getOriginalModel().getBuild() == null) {
            return;
        }
        PluginManagement buildPluginManagement = mavenProject.getOriginalModel().getBuild().getPluginManagement();
        if (buildPluginManagement == null) {
            return;
        }
        if (this.isEbmWebsourcingProject(mavenProject)) {
            this.checkPluginManagementInRootPom(helper, buildPluginManagement);
            for (Profile profile : mavenProject.getOriginalModel().getProfiles()) {
                if (profile.getBuild() == null || profile.getBuild().getPluginManagement() == null) continue;
                this.checkPluginManagementInRootPom(helper, profile.getBuild().getPluginManagement());
            }
        } else {
            this.checkPluginManagementInOtherPom(helper, buildPluginManagement);
            for (Profile profile : mavenProject.getOriginalModel().getProfiles()) {
                if (profile.getBuild() == null || profile.getBuild().getPluginManagement() == null) continue;
                this.checkPluginManagementInOtherPom(helper, profile.getBuild().getPluginManagement());
            }
        }
    }

    private void checkPluginManagementInOtherPom(EnforcerRuleHelper helper, PluginManagement pluginManagement) throws EnforcerRuleException {
        if (pluginManagement == null) {
            return;
        }
        ArrayList<Plugin> guiltyPlugins = new ArrayList<Plugin>();
        List plugins = pluginManagement.getPlugins();
        for (Plugin plugin : plugins) {
            if (plugin.getVersion() == null) continue;
            guiltyPlugins.add(plugin);
        }
        if (guiltyPlugins.isEmpty()) {
            return;
        }
        StringBuffer message = new StringBuffer("Only the pluginManagement section of the global parent project is allowed to define versions for plugins ; following plugins break the rule :\n");
        for (Plugin plugin : guiltyPlugins) {
            message.append("  * ").append(plugin.getArtifactId() + ":" + plugin.getVersion()).append("\n");
        }
        throw new EnforcerRuleException(message.toString());
    }

    private void checkPluginManagementInRootPom(EnforcerRuleHelper helper, PluginManagement pluginManagement) throws EnforcerRuleException {
        if (pluginManagement == null) {
            return;
        }
        ArrayList<Plugin> guiltyPlugins = new ArrayList<Plugin>();
        List plugins = pluginManagement.getPlugins();
        for (Plugin plugin : plugins) {
            if (plugin.getVersion() != null) continue;
            guiltyPlugins.add(plugin);
        }
        if (guiltyPlugins.isEmpty()) {
            return;
        }
        StringBuffer message = new StringBuffer("Plugin must have versions if defined in root POM pluginManagement section ; following plugins break the rule :\n");
        for (Plugin plugin : guiltyPlugins) {
            message.append("  * ").append(plugin.getArtifactId()).append("\n");
        }
        throw new EnforcerRuleException(message.toString());
    }
}

