/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven.enforcerrules;

import com.ebmwebsourcing.tools.maven.enforcerrules.AbstractRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;

public class OnlyInternalSnapshotRepoWithoutTimestampIsAllowedAsDistribRepo
extends AbstractRule {
    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        DistributionManagement distribMan = (DistributionManagement)helper.evaluate("${project.distributionManagement}");
        if (distribMan != null) {
            DeploymentRepository snapshotRepository = distribMan.getSnapshotRepository();
            if (snapshotRepository != null) {
                if (!"http://maven.petalslink.com/public-snapshot".equals(snapshotRepository.getUrl())) {
                    throw new EnforcerRuleException("Project distribution snapshot repository must be our internal snapshot repository: http://maven.petalslink.com/public-snapshot");
                }
                if (snapshotRepository.isUniqueVersion()) {
                    throw new EnforcerRuleException(String.format("Timestamps are forbidden for deployed snapshots on repository '%s'.", snapshotRepository.getId()));
                }
            } else {
                throw new EnforcerRuleException("Project must define a snapshot repository.");
            }
        }
    }
}

