/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven.enforcerrules;

import com.ebmwebsourcing.tools.maven.enforcerrules.AbstractRule;
import java.util.ArrayList;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;

public class ProjectGroupIdEndsWithEclipseShortGroupId
extends AbstractRule {
    @Override
    public void doExecute(EnforcerRuleHelper helper) throws Exception {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("com.ebmwebsourcing.");
        prefixes.add("com.petalslink.");
        prefixes.add("org.petalslink.");
        prefixes.add("");
        String eclipseShortGroupId = (String)helper.evaluate("${eclipse.shortGroupId}");
        if ("unknown".equals(eclipseShortGroupId)) {
            return;
        }
        String groupId = (String)helper.evaluate("${project.groupId}");
        for (String prefix : prefixes) {
            if (!groupId.startsWith(prefix)) continue;
            if (groupId.replaceAll(prefix, "").equals(eclipseShortGroupId)) break;
            throw new EnforcerRuleException("Project eclipse.shortGroupId must be equal to groupId without '" + prefix + "'.");
        }
    }
}

