/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven.enforcerrules;

import com.ebmwebsourcing.tools.maven.enforcerrules.AbstractRule;
import java.util.ArrayList;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;

public class ScmConnectionMustEndLikeGroupId
extends AbstractRule {
    @Override
    public void doExecute(EnforcerRuleHelper helper) throws Exception {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("com.ebmwebsourcing.");
        prefixes.add("com.petalslink.");
        prefixes.add("org.petalslink.");
        String actualScmConnection = String.valueOf(helper.evaluate("${project.scm.connection}"));
        String expectedScmConnectionTail = String.valueOf(helper.evaluate("${project.groupId}"));
        for (String prefix : prefixes) {
            if (!expectedScmConnectionTail.startsWith(prefix)) continue;
            expectedScmConnectionTail = expectedScmConnectionTail.replaceAll(prefix, "");
            break;
        }
        expectedScmConnectionTail = expectedScmConnectionTail.replaceAll("\\.", "/");
        if (!actualScmConnection.endsWith(expectedScmConnectionTail = expectedScmConnectionTail + "/" + String.valueOf(helper.evaluate("${project.name}")))) {
            throw new EnforcerRuleException(String.format("SCM connection does not follow convention ; '%s' should end with '%s'.", actualScmConnection, expectedScmConnectionTail));
        }
    }
}

