/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven.enforcerrules;

import com.ebmwebsourcing.tools.maven.SvnUtil;
import com.ebmwebsourcing.tools.maven.enforcerrules.AbstractRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.project.MavenProject;

public class ScmConnectionMustMatchSvnEntriesIfAny
extends AbstractRule {
    @Override
    public void doExecute(EnforcerRuleHelper helper) throws Exception {
        String actualScmConnection;
        MavenProject mavenProject = (MavenProject)helper.evaluate("${project}");
        String expectedScmConnection = SvnUtil.grepScmConnectionFromSvnEntries(mavenProject);
        if (expectedScmConnection == null) {
            helper.getLog().info((CharSequence)".svn/entries file is not present or not readable ; rule ignored.");
            return;
        }
        if (expectedScmConnection.startsWith("scm:svn:svn:")) {
            expectedScmConnection = expectedScmConnection.replaceFirst("scm:svn:svn:", "scm:svn:https:");
        }
        if (!expectedScmConnection.equals(actualScmConnection = String.valueOf(helper.evaluate("${project.scm.connection}")))) {
            throw new EnforcerRuleException(String.format("Wrong SCM connection '%s' ; '%s' was expected.", actualScmConnection, expectedScmConnection));
        }
    }
}

