/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven.enforcerrules;

import com.ebmwebsourcing.tools.maven.enforcerrules.AbstractRule;
import java.io.File;
import java.net.URI;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;

public class ValidParentRelativePath
extends AbstractRule {
    private static final String SCM_PREFIX_PATTERN = "scm:svn:";

    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject currentMavenProject = (MavenProject)helper.evaluate("${project}");
        MavenProject parentMavenProject = (MavenProject)helper.evaluate("${project.parent}");
        Parent parentNode = currentMavenProject.getOriginalModel().getParent();
        if (parentNode == null) {
            return;
        }
        String parentRelativePath = parentNode.getRelativePath();
        if (parentMavenProject == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
            buffer.append("\tCan not apply the rule (bug maven)\n");
            buffer.append("\tProject contains XML node parent but can not get the object parent.");
            helper.getLog().error((CharSequence)buffer.toString());
            return;
        }
        String parentScmConnection = parentMavenProject.getScm().getConnection();
        String cScmConnection = currentMavenProject.getScm().getConnection();
        String cSvnUrl = cScmConnection.replaceFirst(SCM_PREFIX_PATTERN, "");
        String parentSvnUrl = parentScmConnection.replaceFirst(SCM_PREFIX_PATTERN, "");
        String curProjectPath = new URI(cSvnUrl).getPath();
        String parentProjectPath = new URI(parentSvnUrl).getPath();
        String expectedParentProjectPath = new File(curProjectPath + "/" + parentRelativePath).getParentFile().getCanonicalPath();
        if (ValidParentRelativePath.isWindows()) {
            expectedParentProjectPath = expectedParentProjectPath.replaceAll("\\\\", "/").substring(2);
        }
        if (!expectedParentProjectPath.equals(parentProjectPath)) {
            StringBuilder builder = new StringBuilder("The relative path of the parent is wrong:\n");
            builder.append("\tParent Relative Path: [" + parentRelativePath + "]\n");
            builder.append("\tArtifact: [" + currentMavenProject.getId() + "]\n");
            builder.append("\tParent artifact: [" + parentMavenProject.getId() + "]\n");
            builder.append("\tExpected parent project path: [" + expectedParentProjectPath + "]\n");
            builder.append("\tResolved parent project path: [" + parentProjectPath + "]\n");
            throw new EnforcerRuleException(builder.toString());
        }
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }
}

