/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webcommons.persistence.dao;

import com.ebmwebsourcing.webcommons.persistence.bo.ASearchableClass;
import com.ebmwebsourcing.webcommons.persistence.bo.BSearchableClass;
import com.ebmwebsourcing.webcommons.persistence.bo.CSearchableClass;
import com.ebmwebsourcing.webcommons.persistence.bo.UnitName;
import com.ebmwebsourcing.webcommons.persistence.dao.ADao;
import com.ebmwebsourcing.webcommons.persistence.dao.BDao;
import com.ebmwebsourcing.webcommons.persistence.dao.CDao;
import com.ebmwebsourcing.webcommons.persistence.dao.CommonDAOConfig;
import com.ebmwebsourcing.webcommons.persistence.dao.DAOLayerException;
import com.ebmwebsourcing.webcommons.persistence.dao.util.RequestOptions;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class GenericHibernateDAOImplTest
extends CommonDAOConfig {
    @Resource(name="aDao")
    private ADao aDao;
    @Resource(name="bDao")
    private BDao bDao;
    @Resource(name="cDao")
    private CDao cDao;
    private static ASearchableClass a1;
    private static ASearchableClass a2;
    private static BSearchableClass b1;
    private static BSearchableClass b2;
    private static BSearchableClass b3;
    private static BSearchableClass b4;
    private static CSearchableClass c1;
    private static CSearchableClass c2;
    private static CSearchableClass c3;
    private static UnitName u1;
    private static UnitName u2;
    private static UnitName u3;

    public void createTestData() {
        u1 = new UnitName("u1", "uv1");
        u2 = new UnitName("u2", "uv2");
        u3 = new UnitName("u3", "uv3");
        c1 = new CSearchableClass();
        c2 = new CSearchableClass();
        c3 = new CSearchableClass();
        c1.addName(u1);
        c2.addName(u2);
        c3.addName(u3);
        b1 = new BSearchableClass();
        b1.setAnOrderField("b1");
        b2 = new BSearchableClass();
        b2.setAnOrderField("b2");
        b3 = new BSearchableClass();
        b3.setAnOrderField("b3");
        b4 = new BSearchableClass();
        b4.setAnOrderField("b1");
        b1.addC(c1);
        b1.addC(c2);
        b2.addC(c1);
        b4.addC(c2);
        b4.addC(c3);
        b3.addC(c1);
        a1 = new ASearchableClass();
        a1.setName("a1");
        a1.setValue("av1");
        a2 = new ASearchableClass();
        a2.setName("a2");
        a2.setValue("av1");
        a1.addBClass(b1);
        a1.addBClass(b2);
        a2.addBClass(b3);
        a2.addBClass(b4);
    }

    @Before
    public void registerTestData() {
        this.createTestData();
        this.aDao.save((Object)a1);
        this.aDao.save((Object)a2);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
    }

    @Test
    public void testSearchDeepOnAs() throws DAOLayerException {
        String[] criteria = new String[]{"a1", "u1"};
        String[] searchedProperties = new String[]{"name", "bs.cs.names.name"};
        List result = this.aDao.searchLucene(criteria, searchedProperties);
        GenericHibernateDAOImplTest.assertNotNull((Object)result);
        GenericHibernateDAOImplTest.assertEquals((int)1, (int)result.size());
        GenericHibernateDAOImplTest.assertEquals((String)"a1", (String)((ASearchableClass)((Object)result.get(0))).getName());
    }

    @Test
    public void testSearchDeepOnAs2() throws DAOLayerException {
        String[] criteria = new String[]{"u1"};
        String[] searchedProperties = new String[]{"bs.cs.names.name"};
        List result = this.aDao.searchLucene(criteria, searchedProperties);
        GenericHibernateDAOImplTest.assertNotNull((Object)result);
        GenericHibernateDAOImplTest.assertEquals((int)2, (int)result.size());
    }

    @Test
    public void testSearchDeepOnAsOrderbyAsName() throws DAOLayerException {
        String[] criteria = new String[]{"u1"};
        String[] searchedProperties = new String[]{"bs.cs.names.name"};
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setSortCriteria("name");
        requestOptions.setSortAscendingly(true);
        List result = this.aDao.searchLucene(criteria, searchedProperties, requestOptions);
        GenericHibernateDAOImplTest.assertNotNull((Object)result);
        GenericHibernateDAOImplTest.assertEquals((int)2, (int)result.size());
        GenericHibernateDAOImplTest.assertEquals((String)"a1", (String)((ASearchableClass)((Object)result.get(0))).getName());
        GenericHibernateDAOImplTest.assertEquals((String)"a2", (String)((ASearchableClass)((Object)result.get(1))).getName());
        requestOptions.setSortAscendingly(false);
        List result2 = this.aDao.searchLucene(criteria, searchedProperties, requestOptions);
        GenericHibernateDAOImplTest.assertNotNull((Object)result2);
        GenericHibernateDAOImplTest.assertEquals((int)2, (int)result2.size());
        GenericHibernateDAOImplTest.assertEquals((String)"a2", (String)((ASearchableClass)((Object)result2.get(0))).getName());
        GenericHibernateDAOImplTest.assertEquals((String)"a1", (String)((ASearchableClass)((Object)result2.get(1))).getName());
    }

    @Test
    public void testSearchDeepOnBs() throws DAOLayerException {
        String[] criteria = new String[]{"u1", "b1", "a1"};
        String[] searchedProperties = new String[]{"cs.names.name", "as.name", "anOrderField"};
        List result = this.bDao.searchLucene(criteria, searchedProperties);
        GenericHibernateDAOImplTest.assertNotNull((Object)result);
        GenericHibernateDAOImplTest.assertEquals((int)1, (int)result.size());
        GenericHibernateDAOImplTest.assertEquals((String)"b1", (String)((BSearchableClass)((Object)result.get(0))).getAnOrderField());
    }
}

