/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.agreement.definition.test;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.MonitoringPropertiesType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.ReferenceParametersType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.WSAddressing4AgreementFactory;
import com.ebmwebsourcing.agreement.definition.WSAgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.BusinessValueList;
import com.ebmwebsourcing.agreement.definition.api.Context;
import com.ebmwebsourcing.agreement.definition.api.GuaranteeTerms;
import com.ebmwebsourcing.agreement.definition.api.KPITarget;
import com.ebmwebsourcing.agreement.definition.api.Location;
import com.ebmwebsourcing.agreement.definition.api.Penalty;
import com.ebmwebsourcing.agreement.definition.api.QualifyingCondition;
import com.ebmwebsourcing.agreement.definition.api.Reward;
import com.ebmwebsourcing.agreement.definition.api.ServiceDescription;
import com.ebmwebsourcing.agreement.definition.api.ServiceLevelObjective;
import com.ebmwebsourcing.agreement.definition.api.ServiceProperties;
import com.ebmwebsourcing.agreement.definition.api.ServiceReference;
import com.ebmwebsourcing.agreement.definition.api.ServiceScope;
import com.ebmwebsourcing.agreement.definition.api.Variable;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.qml.WSQMLFactory;
import com.ebmwebsourcing.wsstar.qml.api.Constraint;
import com.ebmwebsourcing.wsstar.qml.api.QOSDimension;
import com.ebmwebsourcing.wsstar.qml.api.Type;
import com.ebmwebsourcing.wsstar.qml.api.Unit;
import com.ebmwebsourcing.wsstar.qml.api.Value;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Properties;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;

public class TestWSAgreementDescriptor
extends TestCase {
    private String TARGET_NAMESPACE = "http://petals.ow2.org/";

    public QName cName(String name) {
        return new QName(this.TARGET_NAMESPACE, name);
    }

    public TestWSAgreementDescriptor(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReaderAgreement() throws WSAgreementException, URISyntaxException {
        Agreement desc = WSAgreementFactory.newInstance().newWSAgreementReader().read(Thread.currentThread().getContextClassLoader().getResource("descriptors/agreementTest.xml"));
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((String)"slaTest", (String)desc.getName());
        System.out.println(desc);
        System.out.println(desc.getName());
    }

    public void testWriterAgreement() throws WSAgreementException, URISyntaxException {
        Agreement desc = WSAgreementFactory.newInstance().newWSAgreementReader().read(Thread.currentThread().getContextClassLoader().getResource("descriptors/agreementTest.xml"));
        String res = WSAgreementFactory.newInstance().newWSAgreementWriter().write(desc);
        System.out.println("xml plat:\n" + res);
        Assert.assertNotNull((Object)res);
        Document doc = WSAgreementFactory.newInstance().newWSAgreementWriter().getDocument(desc);
        Assert.assertNotNull((Object)doc);
    }

    public void testCreateAgreement() throws WSAgreementException, WSAddressingException, MalformedURLException, URISyntaxException, WSQMLException {
        Agreement desc = this.createAgreement();
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((String)"slaTest", (String)desc.getName());
        Assert.assertEquals((String)"initiatorEndpoint", (String)desc.getContext().getInitiator().getAddress());
        Assert.assertEquals((String)"responderEndpoint", (String)desc.getContext().getResponder().getAddress());
        Assert.assertNotNull((Object)desc.getContext().getExpirationTime());
        Assert.assertEquals((String)"term_1", (String)desc.getServiceDescription().getName());
        Assert.assertEquals((String)"responderService", (String)desc.getServiceDescription().getServiceName());
        Assert.assertEquals((Object)new URI("http://com.ebmws/serviceTest.wsdl"), (Object)desc.getServiceDescription().getWsdlDescription());
        Assert.assertEquals((String)"term_1", (String)desc.getServiceReference().getName());
        Assert.assertEquals((String)"responderService", (String)desc.getServiceReference().getServiceName());
        Assert.assertEquals((String)"term_1", (String)desc.getServiceProperties().getName());
        Assert.assertEquals((String)"responderService", (String)desc.getServiceProperties().getServiceName());
        Assert.assertEquals((String)"latency", (String)((Variable)desc.getServiceProperties().getVariables().get(0)).getName());
        Assert.assertEquals((String)"http://wwww.w3.org/2007/ont/unit#s", (String)((Variable)desc.getServiceProperties().getVariables().get(0)).getMetric().toString());
        Assert.assertEquals((String)"http://petals.ow2.org/MonitoringEndpoint", (String)((Variable)desc.getServiceProperties().getVariables().get(0)).getLocation().getAddress().getAddress());
        Assert.assertEquals((String)"http://www.nca.or.kr/2006/wsqdl/QualityFactor/MeasureFactor/Latency", (String)((Variable)desc.getServiceProperties().getVariables().get(0)).getLocation().getQOSDimension().getSemanticConcept());
        Assert.assertEquals((String)"responderService", (String)((ServiceScope)((GuaranteeTerms)desc.getGuaranteeTerms().get(0)).getServiceScopes().get(0)).getServiceName());
        Assert.assertEquals((String)"weatherOperation", (String)((String)((ServiceScope)((GuaranteeTerms)desc.getGuaranteeTerms().get(0)).getServiceScopes().get(0)).getScopes().get(0)));
        Assert.assertEquals((String)"$currentDateTime = weekday", (String)((GuaranteeTerms)desc.getGuaranteeTerms().get(0)).getQualifyingCondition().getExpression().getValue());
        Assert.assertEquals((String)"urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", (String)((GuaranteeTerms)desc.getGuaranteeTerms().get(0)).getQualifyingCondition().getExpression().getExpressionLanguage());
        Assert.assertEquals((String)"latency", (String)((GuaranteeTerms)desc.getGuaranteeTerms().get(0)).getServiceLevelObjective().getKPITarget().getKPIName());
        Assert.assertEquals((int)4, (int)((GuaranteeTerms)desc.getGuaranteeTerms().get(0)).getBusinessValueList().getImportance());
        Assert.assertEquals((Object)new Integer(4), (Object)((Penalty)((GuaranteeTerms)desc.getGuaranteeTerms().get(0)).getBusinessValueList().getPenalties().get(0)).getCount());
        Assert.assertEquals((String)"5", (String)((Penalty)((GuaranteeTerms)desc.getGuaranteeTerms().get(0)).getBusinessValueList().getPenalties().get(0)).getValueExpr());
        Assert.assertEquals((String)"USD", (String)((Penalty)((GuaranteeTerms)desc.getGuaranteeTerms().get(0)).getBusinessValueList().getPenalties().get(0)).getValueUnit());
        Assert.assertEquals((Object)new Long(3000L), (Object)((Reward)((GuaranteeTerms)desc.getGuaranteeTerms().get(0)).getBusinessValueList().getRewards().get(0)).getTimeInterval());
        Assert.assertEquals((String)"5", (String)((Reward)((GuaranteeTerms)desc.getGuaranteeTerms().get(0)).getBusinessValueList().getRewards().get(0)).getValueExpr());
        Assert.assertEquals((String)"USD", (String)((Reward)((GuaranteeTerms)desc.getGuaranteeTerms().get(0)).getBusinessValueList().getRewards().get(0)).getValueUnit());
        Document doc = WSAgreementFactory.newInstance().newWSAgreementWriter().getDocument(desc);
        Assert.assertNotNull((Object)doc);
    }

    private Agreement createAgreement() throws WSAgreementException, WSAddressingException, URISyntaxException, WSQMLException {
        Agreement desc = WSAgreementFactory.newInstance().newAgreement();
        desc.setName("slaTest");
        Context context = desc.newContext();
        desc.setContext(context);
        EndpointReferenceType initiator = WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType();
        initiator.setAddress("initiatorEndpoint");
        EndpointReferenceType responder = WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType();
        responder.setAddress("responderEndpoint");
        context.setInitiator(initiator);
        context.setResponder(responder);
        context.setExpirationTime(Calendar.getInstance().getTime());
        ServiceDescription sd = desc.newServiceDescription();
        desc.setServiceDescription(sd);
        sd.setName("term_1");
        sd.setServiceName("responderService");
        sd.setWsdlDescription(new URI("http://com.ebmws/serviceTest.wsdl"));
        ServiceReference sr = desc.newServiceReference();
        desc.setServiceReference(sr);
        sr.setName("term_1");
        sr.setServiceName("responderService");
        ServiceProperties sp = desc.newServiceProperties();
        desc.setServiceProperties(sp);
        sp.setName("term_1");
        sp.setServiceName("responderService");
        Variable variable = sp.newVariable();
        variable.setName("latency");
        variable.setMetric(new URI("http://wwww.w3.org/2007/ont/unit#s"));
        Location location = variable.newLocation();
        variable.setLocation(location);
        EndpointReferenceType address = WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType();
        address.setAddress("http://petals.ow2.org/MonitoringEndpoint");
        location.setAddress(address);
        ReferenceParametersType ref = (ReferenceParametersType)address.newReferenceParameters();
        address.setReferenceParameters((AbsItfReferenceParametersType)ref);
        MonitoringPropertiesType monprops = ref.newMonitoringPropertiesType();
        ref.setMonitoringPropertiesType(monprops);
        Properties properties = new Properties();
        properties.put("mode", "pull");
        properties.put("operation", "speed");
        monprops.setProperty(properties);
        QOSDimension dim = WSQMLFactory.newInstance().newQOSDimension();
        dim.setSemanticConcept("http://www.nca.or.kr/2006/wsqdl/QualityFactor/MeasureFactor/Latency");
        location.setQOSDimension(dim);
        sp.addVariable(variable);
        GuaranteeTerms guarantee = desc.newGuaranteeTerms();
        desc.addGuarantee(guarantee);
        ServiceScope ss = guarantee.newServiceScope();
        guarantee.addServiceScope(ss);
        ss.setServiceName("responderService");
        ss.addScope("weatherOperation");
        ss.addScope("othersOperation");
        QualifyingCondition qc = guarantee.newQualifyingCondition("$currentDateTime = weekday", "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
        guarantee.setQualifyingCondition(qc);
        ServiceLevelObjective slo = guarantee.newServiceLevelObjective();
        guarantee.setServiceLevelObjective(slo);
        KPITarget target = slo.newKPITarget();
        slo.setKPITarget(target);
        target.setKPIName("latency");
        Constraint constraint = target.newConstraint();
        target.setConstraint(constraint);
        constraint.setOperator("&lt;");
        Value val = constraint.newValue();
        constraint.setValue(val);
        val.setValue(new Float(0.2));
        Unit u = val.newUnit();
        val.setUnit(u);
        u.setName("sec");
        u.setSemanticConcept("http://www.w3.org/2007/ont/unit#s");
        Type t = val.newType();
        val.setType(t);
        t.setName("decimal");
        t.setSemanticConcept("http://www.w3c.org/2001/XMLSchema:decimal");
        BusinessValueList bvl = guarantee.newBusinessValueList();
        guarantee.setBusinessValueList(bvl);
        bvl.setImportance(Integer.valueOf(4));
        Penalty p = bvl.newPenalty();
        bvl.addPenalty(p);
        p.setCount(Integer.valueOf(4));
        p.setValueExpr("5");
        p.setValueUnit("USD");
        Reward r = bvl.newReward();
        bvl.addReward(r);
        r.setTimeInterval(new Long(3000L));
        r.setValueExpr("5");
        r.setValueUnit("USD");
        return desc;
    }
}

