/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.agreement.definition.impl;

import com.ebmwebsourcing.agreement.definition.api.BusinessValueList;
import com.ebmwebsourcing.agreement.definition.api.Penalty;
import com.ebmwebsourcing.agreement.definition.api.Reward;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.agreement.definition.impl.PenaltyImpl;
import com.ebmwebsourcing.agreement.definition.impl.RewardImpl;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.BusinessValueListType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.CompensationType;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.AbstractSchemaElementImpl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class BusinessValueListImpl
extends AbstractSchemaElementImpl<BusinessValueListType>
implements BusinessValueList {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(BusinessValueListImpl.class.getName());
    private List<Penalty> penalties = new ArrayList<Penalty>();
    private List<Reward> rewards = new ArrayList<Reward>();

    public BusinessValueListImpl(BusinessValueListType model, AbstractSchemaElementImpl parent) throws WSAgreementException {
        super((Object)model, parent);
        for (CompensationType penalty : ((BusinessValueListType)this.model).getPenalty()) {
            this.penalties.add(new PenaltyImpl(penalty, this));
        }
        for (CompensationType reward : ((BusinessValueListType)this.model).getReward()) {
            this.rewards.add(new RewardImpl(reward, this));
        }
    }

    @Override
    public Integer getImportance() {
        Integer res = null;
        if (((BusinessValueListType)this.model).getImportance() != null) {
            res = ((BusinessValueListType)this.model).getImportance().intValue();
        }
        return res;
    }

    @Override
    public List<Penalty> getPenalties() {
        return this.penalties;
    }

    @Override
    public List<Reward> getRewards() {
        return this.rewards;
    }

    @Override
    public void setImportance(Integer importance) {
        if (importance != null) {
            ((BusinessValueListType)this.model).setImportance(BigInteger.valueOf(importance.intValue()));
        } else {
            ((BusinessValueListType)this.model).setImportance(null);
        }
    }

    @Override
    public void addPenalty(Penalty penalty) {
        ((BusinessValueListType)this.model).getPenalty().add((CompensationType)((AbstractSchemaElementImpl)penalty).getModel());
        this.penalties.add(penalty);
    }

    @Override
    public void addReward(Reward reward) {
        ((BusinessValueListType)this.model).getReward().add((CompensationType)((AbstractSchemaElementImpl)reward).getModel());
        this.rewards.add(reward);
    }

    @Override
    public void removePenalty(Penalty penalty) {
        ((BusinessValueListType)this.model).getPenalty().remove((CompensationType)((AbstractSchemaElementImpl)penalty).getModel());
        this.penalties.remove(penalty);
    }

    @Override
    public void removeReward(Reward reward) {
        ((BusinessValueListType)this.model).getReward().remove((CompensationType)((AbstractSchemaElementImpl)reward).getModel());
        this.rewards.remove(reward);
    }

    @Override
    public Penalty newPenalty() throws WSAgreementException {
        return new PenaltyImpl(new CompensationType(), this);
    }

    @Override
    public Reward newReward() throws WSAgreementException {
        return new RewardImpl(new CompensationType(), this);
    }
}

