/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.dm.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.dm.WSDMFactory;
import com.ebmwebsourcing.wsstar.dm.api.QoSMetrics;
import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import com.ebmwebsourcing.wsstar.dm.api.expression.QoSDuration;
import com.ebmwebsourcing.wsstar.dm.api.expression.QoSInteger;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestQoSMetrics
extends TestCase {
    public TestQoSMetrics(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public QoSMetrics createQoSMetrics() throws URISyntaxException, WSDMException, DatatypeConfigurationException {
        QoSMetrics metrics = WSDMFactory.newInstance().newQoSMetrics();
        QoSDuration serviceTime = WSDMFactory.newInstance().newQoSDuration();
        serviceTime.setValue((Object)DatatypeFactory.newInstance().newDuration(600L));
        serviceTime.setDuration(DatatypeFactory.newInstance().newDuration(600L));
        serviceTime.setLastUpdated(GregorianCalendar.getInstance().getTime());
        serviceTime.setResetAt(GregorianCalendar.getInstance().getTime());
        QoSDuration maxResponseTime = WSDMFactory.newInstance().newQoSDuration();
        maxResponseTime.setValue((Object)DatatypeFactory.newInstance().newDuration(600L));
        maxResponseTime.setDuration(DatatypeFactory.newInstance().newDuration(600L));
        maxResponseTime.setLastUpdated(GregorianCalendar.getInstance().getTime());
        maxResponseTime.setResetAt(GregorianCalendar.getInstance().getTime());
        QoSDuration lastResponseTime = WSDMFactory.newInstance().newQoSDuration();
        lastResponseTime.setValue((Object)DatatypeFactory.newInstance().newDuration(600L));
        lastResponseTime.setDuration(DatatypeFactory.newInstance().newDuration(600L));
        lastResponseTime.setLastUpdated(GregorianCalendar.getInstance().getTime());
        lastResponseTime.setResetAt(GregorianCalendar.getInstance().getTime());
        QoSInteger numberOfSuccessfulRequests = WSDMFactory.newInstance().newQoSInteger();
        numberOfSuccessfulRequests.setValue((Object)3);
        numberOfSuccessfulRequests.setDuration(DatatypeFactory.newInstance().newDuration(600L));
        numberOfSuccessfulRequests.setLastUpdated(GregorianCalendar.getInstance().getTime());
        numberOfSuccessfulRequests.setResetAt(GregorianCalendar.getInstance().getTime());
        QoSInteger numberOfRequests = WSDMFactory.newInstance().newQoSInteger();
        numberOfRequests.setValue((Object)3);
        numberOfRequests.setDuration(DatatypeFactory.newInstance().newDuration(600L));
        numberOfRequests.setLastUpdated(GregorianCalendar.getInstance().getTime());
        numberOfRequests.setResetAt(GregorianCalendar.getInstance().getTime());
        QoSInteger numberOfFailedRequests = WSDMFactory.newInstance().newQoSInteger();
        numberOfFailedRequests.setValue((Object)3);
        numberOfFailedRequests.setDuration(DatatypeFactory.newInstance().newDuration(600L));
        numberOfFailedRequests.setLastUpdated(GregorianCalendar.getInstance().getTime());
        numberOfFailedRequests.setResetAt(GregorianCalendar.getInstance().getTime());
        QoSInteger maxRequestSize = WSDMFactory.newInstance().newQoSInteger();
        maxRequestSize.setValue((Object)3);
        maxRequestSize.setDuration(DatatypeFactory.newInstance().newDuration(600L));
        maxRequestSize.setLastUpdated(GregorianCalendar.getInstance().getTime());
        maxRequestSize.setResetAt(GregorianCalendar.getInstance().getTime());
        QoSInteger maxResponseSize = WSDMFactory.newInstance().newQoSInteger();
        maxResponseSize.setValue((Object)3);
        maxResponseSize.setDuration(DatatypeFactory.newInstance().newDuration(600L));
        maxResponseSize.setLastUpdated(GregorianCalendar.getInstance().getTime());
        maxResponseSize.setResetAt(GregorianCalendar.getInstance().getTime());
        QoSInteger lastRequestSize = WSDMFactory.newInstance().newQoSInteger();
        lastRequestSize.setValue((Object)3);
        lastRequestSize.setDuration(DatatypeFactory.newInstance().newDuration(600L));
        lastRequestSize.setLastUpdated(GregorianCalendar.getInstance().getTime());
        lastRequestSize.setResetAt(GregorianCalendar.getInstance().getTime());
        QoSInteger lastResponseSize = WSDMFactory.newInstance().newQoSInteger();
        lastResponseSize.setValue((Object)3);
        lastResponseSize.setDuration(DatatypeFactory.newInstance().newDuration(600L));
        lastResponseSize.setLastUpdated(GregorianCalendar.getInstance().getTime());
        lastResponseSize.setResetAt(GregorianCalendar.getInstance().getTime());
        metrics.setOperation("wheather");
        metrics.setPortType(new QName("http://petals.ow2.org/", "wheaterItf"));
        metrics.setServiceTime(serviceTime);
        metrics.setMaxResponseTime(maxResponseTime);
        metrics.setLastResponseTime(lastResponseTime);
        metrics.setNumberOfSuccessfulRequests(numberOfSuccessfulRequests);
        metrics.setNumberOfRequests(numberOfRequests);
        metrics.setNumberOfFailedRequests(numberOfFailedRequests);
        metrics.setMaxRequestSize(maxRequestSize);
        metrics.setMaxResponseSize(maxResponseSize);
        metrics.setLastRequestSize(lastRequestSize);
        metrics.setLastResponseSize(lastResponseSize);
        Assert.assertNotNull((Object)metrics);
        return metrics;
    }

    public void testWriteQoSMetrics() throws URISyntaxException, WSDMException, DatatypeConfigurationException {
        QoSMetrics metrics = this.createQoSMetrics();
        Document doc = WSDMFactory.newInstance().newWSDMWriter().getDocument(metrics);
        System.out.println("metrics:\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadQoSMetrics() throws URISyntaxException, WSDMException, DatatypeConfigurationException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document wsdmDocument = factory.newDocumentBuilder().parse(Thread.currentThread().getContextClassLoader().getResourceAsStream("wsdl/wsdm/qos/metric.xml"));
        QoSMetrics metrics = WSDMFactory.newInstance().newWSDMReader().readOperationMetric(wsdmDocument);
        Document doc = WSDMFactory.newInstance().newWSDMWriter().getDocument(metrics);
        System.out.println("metrics:\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }
}

