/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.TokenWrapper;

public class RecipientToken
extends AbstractSecurityAssertion
implements TokenWrapper {
    private Token recipientToken;

    public RecipientToken(int version) {
        this.setVersion(version);
    }

    public Token getRecipientToken() {
        return this.recipientToken;
    }

    public void setRecipientToken(Token recipientToken) {
        this.recipientToken = recipientToken;
    }

    @Override
    public void setToken(Token tok) {
        this.setRecipientToken(tok);
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.RECIPIENT_TOKEN;
        }
        return SP11Constants.RECIPIENT_TOKEN;
    }

    @Override
    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        RecipientToken.writeStartElement(writer, this.getName());
        RecipientToken.writeStartElement(writer, SPConstants.POLICY);
        Token token = this.getRecipientToken();
        if (token == null) {
            throw new RuntimeException("RecipientToken doesn't contain any token assertions");
        }
        token.serialize(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

