/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;

public class RequiredElements
extends AbstractSecurityAssertion {
    private final List<String> xPathExpressions = new ArrayList<String>();
    private final Map<String, String> declaredNamespaces = new HashMap<String, String>();
    private String xPathVersion;

    public RequiredElements(int version) {
        this.setVersion(version);
    }

    public List<String> getXPathExpressions() {
        return this.xPathExpressions;
    }

    public void addXPathExpression(String expr) {
        this.xPathExpressions.add(expr);
    }

    public String getXPathVersion() {
        return this.xPathVersion;
    }

    public void setXPathVersion(String pathVersion) {
        this.xPathVersion = pathVersion;
    }

    public Map<String, String> getDeclaredNamespaces() {
        return this.declaredNamespaces;
    }

    public void addDeclaredNamespaces(String uri, String prefix) {
        this.declaredNamespaces.put(prefix, uri);
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        RequiredElements.writeStartElement(writer, prefix, localName, namespaceURI);
        if (this.xPathVersion != null) {
            RequiredElements.writeAttribute(writer, prefix, namespaceURI, "XPathVersion", this.xPathVersion);
        }
        for (String xPathExpression : this.xPathExpressions) {
            RequiredElements.writeStartElement(writer, prefix, "XPath", namespaceURI);
            writer.writeCharacters(xPathExpression);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.REQUIRED_ELEMENTS;
        }
        return SP11Constants.REQUIRED_ELEMENTS;
    }

    @Override
    public PolicyComponent normalize() {
        return this;
    }
}

