/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.secpolicy.model.AlgorithmSuite;

public class AlgorithmSuiteBuilder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        AlgorithmSuite algorithmSuite = new AlgorithmSuite(2);
        Policy policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement()).normalize(false);
        Iterator alternatives = policy.getAlternatives();
        if (alternatives.hasNext()) {
            this.processAlternative((List)alternatives.next(), algorithmSuite);
        }
        return algorithmSuite;
    }

    private void processAlternative(List<Assertion> assertions, AlgorithmSuite algorithmSuite) {
        Iterator<Assertion> iterator;
        if (assertions != null && (iterator = assertions.iterator()).hasNext()) {
            Assertion assertion = iterator.next();
            String name = assertion.getName().getLocalPart();
            try {
                algorithmSuite.setAlgorithmSuite(name);
            }
            catch (WSSPolicyException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.ALGORITHM_SUITE};
    }
}

