/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Constants;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.SignedEncryptedElements;

public class EncryptedElementsBuilder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SignedEncryptedElements signedEncryptedElements = new SignedEncryptedElements(false, 2);
        OMAttribute attribute = element.getAttribute(SP12Constants.ATTR_XPATH_VERSION);
        if (attribute != null) {
            signedEncryptedElements.setXPathVersion(attribute.getAttributeValue());
        }
        Iterator iterator = element.getChildElements();
        while (iterator.hasNext()) {
            this.processElement((OMElement)iterator.next(), signedEncryptedElements);
        }
        OMAttribute isOptional = element.getAttribute(Constants.Q_ELEM_OPTIONAL_ATTR);
        if (isOptional != null) {
            signedEncryptedElements.setOptional(Boolean.parseBoolean(isOptional.getAttributeValue()));
        }
        return signedEncryptedElements;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.ENCRYPTED_ELEMENTS};
    }

    private void processElement(OMElement element, SignedEncryptedElements parent) {
        if (SP12Constants.XPATH.equals(element.getQName())) {
            parent.addXPathExpression(element.getText());
            Iterator namespaces = element.getNamespacesInScope();
            while (namespaces.hasNext()) {
                OMNamespace nm = (OMNamespace)namespaces.next();
                parent.addDeclaredNamespaces(nm.getNamespaceURI(), nm.getPrefix());
            }
        }
    }
}

