/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.KerberosToken;

public class KerberosTokenBuilder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory arg1) throws IllegalArgumentException {
        Policy policy;
        Iterator alternatives;
        KerberosToken kerberosToken = new KerberosToken(2);
        OMElement policyElement = element.getFirstElement();
        OMAttribute includeAttr = element.getAttribute(SP12Constants.INCLUDE_TOKEN);
        if (includeAttr != null) {
            int inclusion = SP12Constants.getInclusionFromAttributeValue(includeAttr.getAttributeValue());
            kerberosToken.setInclusion(inclusion);
        }
        if (policyElement != null && (alternatives = (policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement()).normalize(false)).getAlternatives()).hasNext()) {
            this.processAlternative((List)alternatives.next(), kerberosToken);
        }
        return kerberosToken;
    }

    private void processAlternative(List<Assertion> assertions, KerberosToken parent) {
        if (assertions != null) {
            for (Assertion assertion : assertions) {
                QName name = assertion.getName();
                if (SP12Constants.REQUIRE_KERBEROS_V5_TOKEN_11.equals(name)) {
                    parent.setRequiresKerberosV5Token(true);
                    continue;
                }
                if (SP12Constants.REQUIRE_KERBEROS_GSS_V5_TOKEN_11.equals(name)) {
                    parent.setRequiresGssKerberosV5Token(true);
                    continue;
                }
                if (!SP12Constants.REQUIRE_KEY_IDENTIFIRE_REFERENCE.equals(name)) continue;
                parent.setRequiresKeyIdentifierReference(true);
            }
        }
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.KERBEROS_TOKEN};
    }
}

