/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.Layout;

public class LayoutBuilder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        Layout layout = new Layout(2);
        Policy policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement()).normalize(false);
        Iterator alternatives = policy.getAlternatives();
        if (alternatives.hasNext()) {
            this.processAlternative((List)alternatives.next(), layout);
        }
        return layout;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.LAYOUT};
    }

    public void processAlternative(List<Assertion> assertions, Layout parent) {
        if (assertions != null) {
            for (Assertion assertion : assertions) {
                QName qname = assertion.getName();
                if (SP12Constants.STRICT.equals(qname)) {
                    parent.setValue("Strict");
                    continue;
                }
                if (SP12Constants.LAX.equals(qname)) {
                    parent.setValue("Lax");
                    continue;
                }
                if (SP12Constants.LAXTSFIRST.equals(qname)) {
                    parent.setValue("LaxTimestampFirst");
                    continue;
                }
                if (!SP12Constants.LAXTSLAST.equals(qname)) continue;
                parent.setValue("LaxTimestampLast");
            }
        }
    }
}

