/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.SignedEncryptedElements;
import org.apache.ws.secpolicy.model.SignedEncryptedParts;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;

public class SupportingTokensBuilder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        Policy policy;
        Iterator iterator;
        QName name = element.getQName();
        SupportingToken supportingToken = null;
        if (SP12Constants.SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(1, 2);
        } else if (SP12Constants.SIGNED_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(3, 2);
        } else if (SP12Constants.ENDORSING_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(2, 2);
        } else if (SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(4, 2);
        } else if (SP12Constants.ENCRYPTED_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(6, 2);
        } else if (SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(5, 2);
        } else if (SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(7, 2);
        } else if (SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(8, 2);
        }
        OMAttribute isOptional = element.getAttribute(Constants.Q_ELEM_OPTIONAL_ATTR);
        if (isOptional != null && supportingToken != null) {
            supportingToken.setOptional(Boolean.parseBoolean(isOptional.getAttributeValue()));
        }
        if ((iterator = (policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement()).normalize(false)).getAlternatives()).hasNext()) {
            this.processAlternative((List)iterator.next(), supportingToken);
        }
        return supportingToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.SUPPORTING_TOKENS, SP12Constants.SIGNED_SUPPORTING_TOKENS, SP12Constants.ENDORSING_SUPPORTING_TOKENS, SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS, SP12Constants.ENCRYPTED_SUPPORTING_TOKENS, SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS, SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS, SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS};
    }

    private void processAlternative(List<Assertion> assertions, SupportingToken supportingToken) {
        for (Assertion assertion : assertions) {
            QName qname = assertion.getName();
            if (SP12Constants.ALGORITHM_SUITE.equals(qname)) {
                supportingToken.setAlgorithmSuite((AlgorithmSuite)assertion);
                continue;
            }
            if (SP12Constants.SIGNED_PARTS.equals(qname)) {
                supportingToken.setSignedParts((SignedEncryptedParts)assertion);
                continue;
            }
            if (SP12Constants.SIGNED_ELEMENTS.equals(qname)) {
                supportingToken.setSignedElements((SignedEncryptedElements)assertion);
                continue;
            }
            if (SP12Constants.ENCRYPTED_PARTS.equals(qname)) {
                supportingToken.setEncryptedParts((SignedEncryptedParts)assertion);
                continue;
            }
            if (SP12Constants.ENCRYPTED_ELEMENTS.equals(qname)) {
                supportingToken.setEncryptedElements((SignedEncryptedElements)assertion);
                continue;
            }
            if (!(assertion instanceof Token)) continue;
            supportingToken.addToken((Token)assertion);
        }
    }
}

