/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.ws.security.message.token.Reference;

public class SimpleTokenStore
implements TokenStorage,
Serializable {
    protected Map<String, Token> tokens = new Hashtable<String, Token>();
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();

    @Override
    public void add(Token token) throws TrustException {
        block5: {
            if (token != null && !"".equals(token.getId()) && token.getId() != null) {
                this.writeLock.lock();
                try {
                    if (this.tokens.keySet().size() == 0 || !this.tokens.containsKey(token.getId())) {
                        this.tokens.put(token.getId(), token);
                        break block5;
                    }
                    throw new TrustException("tokenAlreadyExists", new String[]{token.getId()});
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
    }

    @Override
    public void update(Token token) throws TrustException {
        if (token != null && token.getId() != null && token.getId().trim().length() != 0) {
            this.writeLock.lock();
            try {
                if (!this.tokens.containsKey(token.getId())) {
                    throw new TrustException("noTokenToUpdate", new String[]{token.getId()});
                }
                this.tokens.put(token.getId(), token);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public String[] getTokenIdentifiers() throws TrustException {
        this.readLock.lock();
        try {
            String[] stringArray = this.tokens.keySet().toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Token[] getValidTokens() throws TrustException {
        return this.getTokens(1, 4);
    }

    @Override
    public Token[] getRenewedTokens() throws TrustException {
        return this.getTokens(4);
    }

    @Override
    public Token[] getCancelledTokens() throws TrustException {
        return this.getTokens(3);
    }

    @Override
    public Token[] getExpiredTokens() throws TrustException {
        return this.getTokens(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token[] getTokens(int ... states) throws TrustException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.readLock.lock();
        try {
            block3: for (Token token : this.tokens.values()) {
                this.processTokenExpiry(token);
                for (int state : states) {
                    if (token.getState() != state) continue;
                    tokens.add(token);
                    continue block3;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        return tokens.toArray(new Token[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token getToken(String id) throws TrustException {
        Token token;
        this.readLock.lock();
        try {
            token = this.tokens.get(id);
            if (token == null) {
                for (Token tempToken : this.tokens.values()) {
                    this.processTokenExpiry(tempToken);
                    OMElement elem = tempToken.getAttachedReference();
                    if (elem != null && id.equals(SimpleTokenStore.getIdFromSTR(elem))) {
                        token = tempToken;
                    }
                    if ((elem = tempToken.getUnattachedReference()) == null || !id.equals(SimpleTokenStore.getIdFromSTR(elem))) continue;
                    token = tempToken;
                }
            } else {
                this.processTokenExpiry(token);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return token;
    }

    @Override
    public void removeToken(String id) {
        this.writeLock.lock();
        try {
            this.tokens.remove(id);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void processTokenExpiry(Token token) throws TrustException {
        if (token.getExpires() != null && token.getExpires().getTime() < System.currentTimeMillis()) {
            token.setState(2);
        }
    }

    public static String getIdFromSTR(OMElement str) {
        OMElement child = str.getFirstElement();
        if (child == null) {
            return null;
        }
        if (child.getQName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"))) {
            return child.getText();
        }
        if (child.getQName().equals(Reference.TOKEN)) {
            String uri = child.getAttributeValue(new QName("URI"));
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1);
            }
            return uri;
        }
        return null;
    }
}

