/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.util.Date;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenRenewer;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.rahas.impl.util.CommonUtil;
import org.apache.rahas.impl.util.SAMLUtils;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.joda.time.DateTime;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.Conditions;
import org.w3c.dom.Element;

public class SAMLTokenRenewer
implements TokenRenewer {
    private String configParamName;
    private OMElement configElement;
    private String configFile;

    @Override
    public SOAPEnvelope renew(RahasData data) throws TrustException {
        OMElement rstrElem;
        MessageContext inMsgCtx = data.getInMessageContext();
        SAMLTokenIssuerConfig config = null;
        if (this.configElement != null) {
            config = new SAMLTokenIssuerConfig(this.configElement.getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
        }
        if (config == null && this.configFile != null) {
            config = new SAMLTokenIssuerConfig(this.configFile);
        }
        if (config == null && this.configParamName != null) {
            Parameter param = inMsgCtx.getParameter(this.configParamName);
            if (param != null && param.getParameterElement() != null) {
                config = new SAMLTokenIssuerConfig(param.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
            } else {
                throw new TrustException("expectedParameterMissing", new String[]{this.configParamName});
            }
        }
        if (config == null) {
            throw new TrustException("configurationIsNull");
        }
        TokenStorage tkStorage = TrustUtil.getTokenStore(inMsgCtx);
        SOAPEnvelope env = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
        int wstVersion = data.getVersion();
        if (1 == wstVersion) {
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
        } else {
            OMElement rstrcElem = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, rstrcElem);
        }
        ClassLoader classLoader = inMsgCtx.getAxisService().getClassLoader();
        Crypto crypto = config.getIssuerCrypto(classLoader);
        TrustUtil.createTokenTypeElement(wstVersion, rstrElem).setText("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        Date creationTime = new Date();
        Date expirationTime = new Date();
        expirationTime.setTime(creationTime.getTime() + config.getTtl());
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        TrustUtil.createLifetimeElement(wstVersion, rstrElem, zulu.format(creationTime), zulu.format(expirationTime));
        Token tk = tkStorage.getToken(data.getTokenId());
        OMElement assertionOMElement = tk.getToken();
        Assertion samlAssertion = SAMLUtils.buildAssertion((Element)assertionOMElement);
        if (samlAssertion.getConditions() == null) {
            samlAssertion.setConditions((Conditions)CommonUtil.buildXMLObject(Conditions.DEFAULT_ELEMENT_NAME));
        }
        samlAssertion.getConditions().setNotBefore(new DateTime((Object)creationTime));
        samlAssertion.getConditions().setNotOnOrAfter(new DateTime((Object)expirationTime));
        SAMLUtils.signAssertion(samlAssertion, crypto, config.getIssuerKeyAlias(), config.getIssuerKeyPassword());
        OMElement reqSecTokenElem = TrustUtil.createRequestedSecurityTokenElement(wstVersion, rstrElem);
        Element tempNode = samlAssertion.getDOM();
        reqSecTokenElem.addChild((OMNode)((Element)rstrElem).getOwnerDocument().importNode(tempNode, true));
        return env;
    }

    @Override
    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public void setConfigurationElement(OMElement configElement) {
        this.configElement = configElement;
    }

    @Override
    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }
}

