/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.security.SecureRandom;
import java.util.Base64;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.AbstractIssuerConfig;
import org.apache.rahas.impl.util.CommonUtil;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.P_SHA1;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TokenIssuerUtil {
    public static final String ENCRYPTED_KEY = "EncryptedKey";
    public static final String BINARY_SECRET = "BinarySecret";

    public static byte[] getSharedSecret(RahasData data, int keyComputation, int keySize) throws TrustException {
        boolean requestEntropyPresent = data.getRequestEntropy() != null;
        try {
            if (requestEntropyPresent && keyComputation != 3) {
                if (keyComputation == 2) {
                    data.setResponseEntropy(WSSecurityUtil.generateNonce((int)(keySize / 8)));
                    P_SHA1 p_sha1 = new P_SHA1();
                    return p_sha1.createKey(data.getRequestEntropy(), data.getResponseEntropy(), 0, (long)(keySize / 8));
                }
                return data.getRequestEntropy();
            }
            return TokenIssuerUtil.generateEphemeralKey(keySize);
        }
        catch (WSSecurityException | ConversationException e) {
            throw new TrustException("errorCreatingEphemeralKey", e);
        }
    }

    public static void handleRequestedProofToken(RahasData data, int wstVersion, AbstractIssuerConfig config, OMElement requestedSecurityTokenResponseElement, Token token, Document doc) throws TrustException {
        OMElement reqProofTokElem = TrustUtil.createRequestedProofTokenElement(wstVersion, requestedSecurityTokenResponseElement);
        if (config.keyComputation == 2 && data.getRequestEntropy() != null) {
            OMElement responseEntropyElement = TrustUtil.createEntropyElement(wstVersion, requestedSecurityTokenResponseElement);
            String responseEntropy = Base64.getEncoder().encodeToString(data.getResponseEntropy());
            OMElement binSecElem = TrustUtil.createBinarySecretElement(wstVersion, responseEntropyElement, "/Nonce");
            binSecElem.setText(responseEntropy);
            OMElement compKeyElem = TrustUtil.createComputedKeyElement(wstVersion, reqProofTokElem);
            compKeyElem.setText(data.getWstNs() + "/CK/PSHA1");
        } else if (ENCRYPTED_KEY.equals(config.proofKeyType)) {
            WSSecEncryptedKey encryptedKeyBuilder = new WSSecEncryptedKey();
            ClassLoader classLoader = data.getInMessageContext().getAxisService().getClassLoader();
            Crypto crypto = config.cryptoElement != null ? CommonUtil.getCrypto(TrustUtil.toProperties(config.cryptoElement), classLoader) : CommonUtil.getCrypto(config.cryptoPropertiesFile, classLoader);
            encryptedKeyBuilder.setKeyIdentifierType(8);
            try {
                encryptedKeyBuilder.setUseThisCert(data.getClientCert());
                encryptedKeyBuilder.prepare(doc, crypto);
            }
            catch (WSSecurityException e) {
                throw new TrustException("errorInBuildingTheEncryptedKeyForPrincipal", new String[]{data.getClientCert().getSubjectDN().getName()});
            }
            Element encryptedKeyElem = encryptedKeyBuilder.getEncryptedKeyElement();
            Element bstElem = encryptedKeyBuilder.getBinarySecurityTokenElement();
            if (bstElem != null) {
                reqProofTokElem.addChild((OMNode)((OMElement)bstElem));
            }
            reqProofTokElem.addChild((OMNode)((OMElement)encryptedKeyElem));
            token.setSecret(encryptedKeyBuilder.getEphemeralKey());
        } else if (BINARY_SECRET.equals(config.proofKeyType)) {
            byte[] secret = TokenIssuerUtil.getSharedSecret(data, config.keyComputation, config.keySize);
            OMElement binSecElem = TrustUtil.createBinarySecretElement(wstVersion, reqProofTokElem, null);
            String encodedSecretText = Base64.getEncoder().encodeToString(secret);
            binSecElem.setText(encodedSecretText);
            token.setSecret(secret);
        } else {
            throw new IllegalArgumentException(config.proofKeyType);
        }
    }

    private static byte[] generateEphemeralKey(int keySize) throws TrustException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[keySize / 8];
            random.nextBytes(temp);
            return temp;
        }
        catch (Exception e) {
            throw new TrustException("errorCreatingEphemeralKey", e);
        }
    }
}

