/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl.util;

import java.security.cert.CertificateEncodingException;
import java.util.List;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.dom.DOMMetaFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.rahas.RahasData;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.rahas.impl.TokenIssuerUtil;
import org.apache.rahas.impl.util.SAMLCallbackHandler;
import org.apache.rahas.impl.util.SAMLUtils;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.Loader;
import org.opensaml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.encryption.EncryptedKey;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CommonUtil {
    private static final Logger LOGGER = LogManager.getLogger(CommonUtil.class);

    public static Document getOMDOMDocument() throws TrustException {
        DOMMetaFactory metaFactory = (DOMMetaFactory)OMAbstractFactory.getMetaFactory((String)"dom");
        DocumentBuilderFactory dbf = metaFactory.newDocumentBuilderFactory();
        try {
            return dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new TrustException("Error creating Axiom compatible DOM Document", e);
        }
    }

    public static java.security.cert.X509Certificate getCertificateByAlias(Crypto crypto, String alias) throws TrustException {
        java.security.cert.X509Certificate[] certificates = CommonUtil.getCertificatesByAlias(crypto, alias);
        if (certificates.length == 0) {
            LOGGER.error("Unable to retrieve certificate for alias " + alias);
            throw new TrustException("issuerCertificateNotFound");
        }
        return certificates[0];
    }

    public static java.security.cert.X509Certificate[] getCertificatesByAlias(Crypto crypto, String alias) throws TrustException {
        CryptoType type = new CryptoType(CryptoType.TYPE.ALIAS);
        type.setAlias(alias);
        try {
            java.security.cert.X509Certificate[] certificates = crypto.getX509Certificates(type);
            if (certificates == null) {
                LOGGER.debug("Unable to retrieve certificate for alias " + alias);
                return new java.security.cert.X509Certificate[0];
            }
            return certificates;
        }
        catch (WSSecurityException e) {
            LOGGER.error("Unable to retrieve certificate for alias " + alias, (Throwable)e);
            throw new TrustException("issuerCertificateNotFound", e);
        }
    }

    public static byte[] getDecryptedBytes(CallbackHandler callbackHandler, Crypto crypto, Node encryptedKeyElement) throws WSSecurityException {
        EncryptedKeyProcessor encryptedKeyProcessor = new EncryptedKeyProcessor();
        RequestData requestData = new RequestData();
        requestData.setCallbackHandler(callbackHandler);
        requestData.setDecCrypto(crypto);
        WSSConfig cfg = WSSConfig.getNewInstance();
        requestData.setWssConfig(cfg);
        WSDocInfo docInfo = new WSDocInfo(encryptedKeyElement.getOwnerDocument());
        List resultList = encryptedKeyProcessor.handleToken((Element)encryptedKeyElement, requestData, docInfo);
        WSSecurityEngineResult wsSecurityEngineResult = (WSSecurityEngineResult)resultList.get(0);
        return (byte[])wsSecurityEngineResult.get((Object)"secret");
    }

    public static Crypto getCrypto(Properties properties, ClassLoader classLoader) throws TrustException {
        try {
            return CryptoFactory.getInstance((Properties)properties, (ClassLoader)classLoader);
        }
        catch (WSSecurityException e) {
            LOGGER.error("An error occurred while loading crypto properties", (Throwable)e);
            throw new TrustException("errorLoadingCryptoProperties", e);
        }
    }

    public static Crypto getCrypto(String propertiesFile, ClassLoader classLoader) throws TrustException {
        try {
            return CryptoFactory.getInstance((String)propertiesFile, (ClassLoader)classLoader);
        }
        catch (WSSecurityException e) {
            LOGGER.error("An error occurred while loading crypto properties with property file " + propertiesFile, (Throwable)e);
            throw new TrustException("errorLoadingCryptoProperties", new Object[]{propertiesFile}, e);
        }
    }

    public static SAMLTokenIssuerConfig getTokenIssuerConfiguration(OMElement configElement, String configFile, Parameter messageContextParameter) throws TrustException {
        SAMLTokenIssuerConfig tokenIssuerConfiguration = CommonUtil.createTokenIssuerConfiguration(configElement);
        if (tokenIssuerConfiguration == null) {
            tokenIssuerConfiguration = CommonUtil.createTokenIssuerConfiguration(configFile);
            if (tokenIssuerConfiguration == null) {
                if (messageContextParameter != null) {
                    tokenIssuerConfiguration = CommonUtil.createTokenIssuerConfiguration(messageContextParameter);
                }
                return tokenIssuerConfiguration;
            }
            return tokenIssuerConfiguration;
        }
        return tokenIssuerConfiguration;
    }

    protected static SAMLTokenIssuerConfig createTokenIssuerConfiguration(OMElement configElement) throws TrustException {
        if (configElement != null) {
            LOGGER.debug("Creating token issuer configuration using OMElement");
            return new SAMLTokenIssuerConfig(configElement.getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
        }
        return null;
    }

    protected static SAMLTokenIssuerConfig createTokenIssuerConfiguration(String configFile) throws TrustException {
        if (configFile != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating token issuer configuration using file " + configFile);
            }
            return new SAMLTokenIssuerConfig(configFile);
        }
        return null;
    }

    protected static SAMLTokenIssuerConfig createTokenIssuerConfiguration(Parameter messageContextParameter) throws TrustException {
        if (messageContextParameter != null && messageContextParameter.getParameterElement() != null) {
            LOGGER.debug("Creating token issuer configuration using the config parameter");
            return new SAMLTokenIssuerConfig(messageContextParameter.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
        }
        return null;
    }

    public static XMLObject buildXMLObject(QName objectQName) throws TrustException {
        XMLObjectBuilder builder = Configuration.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            LOGGER.debug("Unable to find OpenSAML builder for object " + objectQName);
            throw new TrustException("builderNotFound", new Object[]{objectQName});
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    public static KeyInfo getSymmetricKeyBasedKeyInfo(Document doc, RahasData data, java.security.cert.X509Certificate serviceCert, int keySize, Crypto crypto, int keyComputation) throws WSSecurityException, TrustException {
        byte[] ephemeralKey = TokenIssuerUtil.getSharedSecret(data, keyComputation, keySize);
        WSSecEncryptedKey encryptedKey = CommonUtil.getSymmetricKeyBasedKeyInfoContent(doc, ephemeralKey, serviceCert, crypto);
        byte[] tempKey = new byte[keySize / 8];
        System.arraycopy(encryptedKey.getEphemeralKey(), 0, tempKey, 0, keySize / 8);
        data.setEphmeralKey(tempKey);
        EncryptedKey samlEncryptedKey = SAMLUtils.createEncryptedKey(serviceCert, encryptedKey);
        return SAMLUtils.createKeyInfo(samlEncryptedKey);
    }

    static WSSecEncryptedKey getSymmetricKeyBasedKeyInfoContent(Document doc, byte[] ephemeralKey, java.security.cert.X509Certificate serviceCert, Crypto crypto) throws WSSecurityException, TrustException {
        WSSecEncryptedKey encryptedKeyBuilder = new WSSecEncryptedKey();
        encryptedKeyBuilder.setKeyIdentifierType(8);
        encryptedKeyBuilder.setUseThisCert(serviceCert);
        encryptedKeyBuilder.setEphemeralKey(ephemeralKey);
        encryptedKeyBuilder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        encryptedKeyBuilder.prepare(doc, crypto);
        return encryptedKeyBuilder;
    }

    public static KeyInfo getCertificateBasedKeyInfo(java.security.cert.X509Certificate certificate) throws TrustException {
        X509Data x509Data = CommonUtil.createX509Data(certificate);
        return SAMLUtils.createKeyInfo(x509Data);
    }

    static X509Data createX509Data(java.security.cert.X509Certificate clientCert) throws TrustException {
        byte[] clientCertBytes;
        try {
            clientCertBytes = clientCert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            LOGGER.error("An error occurred while encoding certificate.", (Throwable)e);
            throw new TrustException("An error occurred while encoding certificate.", e);
        }
        String base64Cert = Base64.encode((byte[])clientCertBytes);
        X509Certificate x509Certificate = (X509Certificate)CommonUtil.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
        x509Certificate.setValue(base64Cert);
        X509Data x509Data = (X509Data)CommonUtil.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
        x509Data.getX509Certificates().add(x509Certificate);
        return x509Data;
    }

    public static SAMLCallbackHandler getSAMLCallbackHandler(SAMLTokenIssuerConfig tokenIssuerConfiguration, RahasData data) throws TrustException {
        if (tokenIssuerConfiguration.getCallbackHandler() != null) {
            return tokenIssuerConfiguration.getCallbackHandler();
        }
        if (tokenIssuerConfiguration.getCallbackHandlerName() != null && tokenIssuerConfiguration.getCallbackHandlerName().trim().length() > 0) {
            SAMLCallbackHandler handler;
            Class cbClass;
            MessageContext msgContext = data.getInMessageContext();
            ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
            try {
                cbClass = Loader.loadClass((ClassLoader)classLoader, (String)tokenIssuerConfiguration.getCallbackHandlerName());
            }
            catch (ClassNotFoundException e) {
                throw new TrustException("cannotLoadPWCBClass", new String[]{tokenIssuerConfiguration.getCallbackHandlerName()}, e);
            }
            try {
                handler = (SAMLCallbackHandler)cbClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new TrustException("cannotCreatePWCBInstance", new String[]{tokenIssuerConfiguration.getCallbackHandlerName()}, e);
            }
            return handler;
        }
        return null;
    }
}

