/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.api;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface Include  extends SchemaElement {

	  /**
	   * Set the location URI of this import.
	   *
	   * @param locationURI the desired location URI
	   */
	  public void setLocationURI(String locationURI);

	  /**
	   * Get the location URI of this import.
	   */
	  public String getLocationURI();

	  /**
	   * This property can be used to hang a referenced Schema,
	   * and the top-level Schema (i.e. the one with the &lt;import&gt;)
	   * will use this Schema when resolving referenced parts.
	   * This would need to be made into a generic reference to handle
	   * other types of referenced documents.
	   */
	  public void setSchema(Schema schema);

	  /**
	   * This property can be used to hang a referenced Schema,
	   * and the top-level Schema (i.e. the one with the &lt;import&gt;)
	   * will use this Schema when resolving referenced  parts.
	   * This would need to be made into a generic reference to handle
	   * other types of referenced documents.
	   */
	  public Schema getSchema();
}
