/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.api.abstractElmt;

import com.ebmwebsourcing.commons.schema.api.Attribute;
import com.ebmwebsourcing.commons.schema.api.Element;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.Type;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractAttribute<E> extends AbstractSchemaElement<E> implements Attribute {

	/**
	 * the schema
	 */
	protected Schema schema;

	/**
	 * the type of element
	 */
	protected Type type;


	/**
	 * referenced attribute
	 */
	protected Attribute referencedAttribute;

	/**
	 *
	 * @param model
	 * @param schema
	 */
	public AbstractAttribute(E model, Schema schema) {
		this.model = model;
		this.schema = schema;
		this.referencedAttribute = null;
	}


	public Schema getSchema() {
		return schema;
	}

	public Type getType() {
		return type;
	}


	public org.jdom.Attribute generateAttribute(Element eIn, String value) {
		org.jdom.Attribute attr = null;
		if(this.getName() != null) {
			String prefix = null;
			org.jdom.Namespace ns = null;
			if(!this.getNamespaceUri().equals(eIn.getQName().getNamespaceURI())) {
				if(((AbstractElement<Element>)eIn).getSchema().getAllNamespaces().getPrefix(this.getNamespaceUri()) != null) {
					prefix = ((AbstractElement<Element>)eIn).getSchema().getAllNamespaces().getPrefix(this.getNamespaceUri());
					ns = org.jdom.Namespace.getNamespace(prefix, this.getNamespaceUri());
				}
			}
			attr = new org.jdom.Attribute(this.getName(), value, ns);
		}
		return attr;
	}
	
	public String toString() {
		return this.getName();
	}
}
