/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;

import org.w3._2001.xmlschema.Group.ParticleItem;

import com.ebmwebsourcing.commons.schema.api.ComplexType;
import com.ebmwebsourcing.commons.schema.api.Element;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.SimpleType;
import com.ebmwebsourcing.commons.schema.api.Type;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractElement<E> extends AbstractSchemaElement<E> implements Element {

	/**
	 * the schema
	 */
	protected Schema schema;

	/**
	 * the type of element
	 */
	protected Type type;
	
	/**
	 * referenced element
	 */
	protected Element referencedElement;

	/**
	 *
	 * @param model
	 * @param schema
	 */
	public AbstractElement(E model, Schema schema) {
		this.model = model;
		this.schema = schema;
		this.referencedElement = null;
	}

	public Type getType() {
		return type;
	}

	public String printXml(Object value) throws SchemaException {
		String res = null;
		if(type != null) {
			if(type instanceof SimpleType) {
				res = ((AbstractType)type).printXml(this, (String)value);
			} else if(type instanceof ComplexType) {
				List<String> newValue = new ArrayList<String>();
				if(value instanceof String) {
					newValue.add((String)value);
				} else if(value instanceof List) {
					newValue.addAll((List<String>)value);
				}
				res = ((AbstractType)type).printXml(this, (List<String>)newValue);
			}
		}
		return res;
	}

	public Schema getSchema() {
		return schema;
	}


	public org.jdom.Element generateElement(Object values) throws SchemaException {

		// create element
		org.jdom.Element eOut = new org.jdom.Element(this.getQName().getLocalPart());
		eOut.setNamespace(org.jdom.Namespace.getNamespace(this.getQName().getPrefix(), this.getQName().getNamespaceURI()));

		// add type attribute on element
		if(((AbstractElement<Element>)this).getType() != null) {
			String type = null;
			// if not a anonymous type
			if(((AbstractElement<Element>)this).getType().getQName() != null) {
				if(((AbstractElement<Element>)this).getSchema().getAllNamespaces().getPrefix(((AbstractElement<Element>)this).getType().getQName().getNamespaceURI()) != null) {
					type = ((AbstractElement<Element>)this).getSchema().getAllNamespaces().getPrefix(((AbstractElement<Element>)this).getType().getQName().getNamespaceURI()) + ":" + ((AbstractElement<Element>)this).getType().getQName().getLocalPart();
					eOut.setAttribute("type", type);
				} else {
					type = ((AbstractElement<Element>)this).getType().getQName().getLocalPart();
					eOut.setAttribute("type", type);
				}
			}
		}

		// if complextype, generate under element
		if(((AbstractElement<Element>)this).getType() instanceof ComplexType) {
			if(((org.w3._2001.xmlschema.ComplexType)((com.ebmwebsourcing.commons.schema.impl.ComplexType)((AbstractElement<Element>)this).getType()).getModel()) != null) {

				List<ParticleItem> items = null;


				if(((org.w3._2001.xmlschema.ComplexType)((com.ebmwebsourcing.commons.schema.impl.ComplexType)((AbstractElement<Element>)this).getType()).getModel()).getSequence() != null) {
					// if sequence
					items = ((org.w3._2001.xmlschema.ComplexType)((com.ebmwebsourcing.commons.schema.impl.ComplexType)((AbstractElement<Element>)this).getType()).getModel()).getSequence().getParticleItems();
				} else if(((org.w3._2001.xmlschema.ComplexType)((com.ebmwebsourcing.commons.schema.impl.ComplexType)((AbstractElement<Element>)this).getType()).getModel()).getAll() != null) {
					// if all
					items = ((org.w3._2001.xmlschema.ComplexType)((com.ebmwebsourcing.commons.schema.impl.ComplexType)((AbstractElement<Element>)this).getType()).getModel()).getAll().getParticleItems();
				}

				if(items != null) {
					for(ParticleItem item: items) {

						// is element
						if(item.getItemElement() != null) {
							if(item.getItemElement().getRef() == null) {
								// is an element
								Element e = new com.ebmwebsourcing.commons.schema.impl.Element(item.getItemElement(), ((AbstractElement)this).getSchema());
								eOut.addContent(((AbstractElement)e).generateElement(nextValue(values)));
							} else {
								// is a ref on an element
								Element e = ((AbstractElement)this).getSchema().getElement(item.getItemElement().getRef());
								eOut.addContent(((AbstractElement)e).generateElement(nextValue(values)));
							}
						}
					}
				}

				// handle attribute
				for(com.ebmwebsourcing.commons.schema.api.Attribute attr: ((ComplexType)((AbstractElement<Element>)this).getType()).getAttributes()) {
					org.jdom.Attribute a = ((AbstractAttribute)attr).generateAttribute(this, nextValue(values));
					eOut.setAttribute(a);
				}

			}
		} else {
			// add value on the simpletype
			String val = nextValue(values);
			if(val != null) {
				eOut.setText(val);
			}
		}
		return eOut;
	}

	private String nextValue(Object values) {
		String res = null;
		if(values instanceof List) {
			res = (String) ((List)values).get(0);
		} else if(values instanceof String) {
			res = (String) values;
		}
		return res;
	}

	public String toString() {
		return this.getQName().toString();
	}
}
