package com.ebmwebsourcing.commons.schema.impl;

import org.apache.commons.lang.NotImplementedException;

import com.ebmwebsourcing.commons.schema.SchemaFactory;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.Type;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractAttribute;

public class Attribute extends AbstractAttribute<org.w3._2001.xmlschema.Attribute> implements
com.ebmwebsourcing.commons.schema.api.Attribute {

	/**
	 *
	 * @param model
	 * @param schema
	 */
	public Attribute(org.w3._2001.xmlschema.Attribute model, Schema schema) {
		super(model, schema);

		if(SchemaFactory.getDefaultSchema() != null) {
			// type define in schema
			for (Type t : schema.getTypes()) {
				if(t.getQName().equals(this.model.getType())) {
					this.type = t;
					break;
				}
			}

			// type define in default schema
			if(this.type == null) {
				if(SchemaFactory.getDefaultSchema() != null) {
					for (Type t : SchemaFactory.getDefaultSchema().getTypes()) {
						if(t.getQName().equals(this.model.getType())) {
							this.type = t;
							break;
						}
					}
				}
			}
		}


		// if referenced attribute
		if(this.model.getRef() != null) {
			this.referencedAttribute = this.schema.getAttribute(this.model.getRef());;
		}

	}

	public String getName() {
		String name = null;
		if(this.model.getName() != null) {
			name = this.model.getName();
		} else if(this.referencedAttribute != null){
			name = this.referencedAttribute.getName();
		}
		return name;
	}

	public String getNamespaceUri() {
		String ns = null;
		if(this.model.getName() != null) {
			ns = this.schema.getTargetNamespace();
		} else if(this.referencedAttribute != null){
			ns = this.referencedAttribute.getNamespaceUri();
		}
		return ns;
	}

	public String getValue() {
		throw new NotImplementedException();
	}

}
