/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.commons.schema.SchemaFactory;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.Type;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractElement;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class Element extends AbstractElement<org.w3._2001.xmlschema.Element> implements com.ebmwebsourcing.commons.schema.api.Element {

	/**
	 *
	 * @param model
	 * @param schema
	 * @throws SchemaException
	 */
	public Element(org.w3._2001.xmlschema.Element model, Schema schema) throws SchemaException {
		super(model, schema);

//		if(SchemaFactory.getDefaultSchema() != null) {
//			// type define in schema
//			for (Type t : schema.getTypes()) {
//				if(t.getQName().equals(this.model.getType())) {
//					this.type = t;
//					break;
//				}
//			}
//
//			// type define in default schema
//			if(this.type == null) {
//				if(SchemaFactory.getDefaultSchema() != null) {
//					for (Type t : SchemaFactory.getDefaultSchema().getTypes()) {
//						if(t.getQName().equals(this.model.getType())) {
//							this.type = t;
//							break;
//						}
//					}
//				}
//			}
//		}

		// if anonymous element
		if(this.model.getComplexType() != null) {
			this.type = new ComplexType(this.model.getComplexType(), schema);
		} else if(this.model.getSimpleType() != null) {
			this.type = new SimpleType(this.model.getSimpleType(), schema);
		} else if(this.model.getType() != null) {
			this.type = this.schema.getType(this.model.getType());
			if(this.type == null) {
				this.type = SchemaFactory.getDefaultSchema().getType(this.model.getType());
			}
		}


		// if referenced element
		if(this.model.getRef() != null) {
			this.referencedElement = this.schema.getElement(this.model.getRef());
			this.type = this.referencedElement.getType();
		}

		if(this.type == null) {
			throw new SchemaException("Error: no type found for this element: " + this);
		}
	}

	public QName getQName() {
		QName ns = null;
		if(this.referencedElement == null) {
			String prefix = this.schema.getAllNamespaces().getPrefix(this.schema.getTargetNamespace());
			if(prefix != null) {
				ns = new QName(this.schema.getTargetNamespace(), this.model.getName(), prefix);
			} else {
				ns = new QName(this.schema.getTargetNamespace(), this.model.getName());
			}
		} else {
			ns = this.referencedElement.getQName();
		}
		return ns;
	}



}
