/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.impl;

import java.net.URI;
import java.util.Map;

import org.apache.commons.lang.NotImplementedException;
import org.w3._2001.xmlschema.Annotated;
import org.w3._2001.xmlschema.OpenAttrs;

import com.ebmwebsourcing.commons.schema.api.Import;
import com.ebmwebsourcing.commons.schema.api.Include;
import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.SimpleType;
import com.ebmwebsourcing.commons.schema.api.SchemaReader.FeatureConstants;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractSchema;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class Schema extends AbstractSchema<org.w3._2001.xmlschema.Schema> implements com.ebmwebsourcing.commons.schema.api.Schema {

	public Schema(URI baseURI, org.w3._2001.xmlschema.Schema schema, org.jdom.Document doc, Map<FeatureConstants, Object> features) throws SchemaException {
		super(baseURI, schema, doc);
		
		this.features = features;
		this.model = schema;
		

		for(OpenAttrs item: this.model.getIncludeOrImportOrRedefine()) {
			// get imports
			if(item instanceof org.w3._2001.xmlschema.Import) {
				Import impt = new com.ebmwebsourcing.commons.schema.impl.Import((org.w3._2001.xmlschema.Import)item, this);
				this.imports.add(impt);
			}
			
			// get includes
			if(item instanceof org.w3._2001.xmlschema.Include) {
				Include incl = new com.ebmwebsourcing.commons.schema.impl.Include((org.w3._2001.xmlschema.Include)item, this);
				this.includes.add(incl);
			}
		}
		this.addImportElementsInAllList();
		this.addIncludeElementsInAllList();
		
		for (Annotated item : this.model.getSimpleTypeOrComplexTypeOrGroup()) {

			// get simple type
			if(item instanceof org.w3._2001.xmlschema.SimpleType) {
				SimpleType st = new com.ebmwebsourcing.commons.schema.impl.SimpleType((org.w3._2001.xmlschema.SimpleType) item, this);
				this.addType(st);
			}

			// get complex type
			if(item instanceof org.w3._2001.xmlschema.ComplexType) {
				ComplexType ct = new com.ebmwebsourcing.commons.schema.impl.ComplexType((org.w3._2001.xmlschema.ComplexType) item, this);
				this.addType(ct);
			}
		}

		for (Annotated item : this.model.getSimpleTypeOrComplexTypeOrGroup()) {

			// get elements
			if(item instanceof org.w3._2001.xmlschema.Element) {
				Element e = new com.ebmwebsourcing.commons.schema.impl.Element((org.w3._2001.xmlschema.Element) item, this);
				this.addElement(e);
			}

			// get attributes
			if(item instanceof org.w3._2001.xmlschema.Attribute) {
				Attribute a = new com.ebmwebsourcing.commons.schema.impl.Attribute((org.w3._2001.xmlschema.Attribute) item, this);
				this.addAttribute(a);
			}
		}
		

	}

	public String getTargetNamespace() {
		return this.model.getTargetNamespace();

	}

	public Import removeImport(Import importDef) {
		throw new NotImplementedException();
	}

	public Include removeInclude(Include includeDef) throws SchemaException {
		throw new NotImplementedException();
	}

}
