/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;

import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.XmlException;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractSchemaReader;
import com.ebmwebsourcing.commons.schema.util.JDomAnalyzer;
import com.ebmwebsourcing.commons.schema.util.SourceHelper;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class SchemaReader extends AbstractSchemaReader implements
com.ebmwebsourcing.commons.schema.api.SchemaReader {

	/**
	 * The JAXB unique unmarshaller.
	 */
	private static Unmarshaller unmarshaller = null;

	/**
	 * The exception raised during JAXB unique unmarshaller creation.
	 */
	private static SchemaException unmarshallerCreationEx = null;

	/*
	 * Private object initializations
	 */
	static {
		try {

			SchemaJAXBContext.createContext();

			unmarshaller = SchemaJAXBContext.getJaxbContext().createUnmarshaller();
			//			unmarshaller.setSchema(schema);
		} catch (JAXBException e) {
			final SchemaException jaxbContextCreationEx = new SchemaException(
					"Failed to create jaxb context", e);
			unmarshallerCreationEx = new SchemaException(
					"Failed to create the JAXB unmarshaller", jaxbContextCreationEx);

		} catch (SchemaException e) {
			final SchemaException jaxbContextCreationEx = new SchemaException(
					"Failed to create jaxb context", e);
			unmarshallerCreationEx = new SchemaException(
					"Failed to create the JAXB unmarshaller", jaxbContextCreationEx);

		}
	}


	private static org.w3._2001.xmlschema.Schema convertStream2Schema(final Source schemaDescriptorStream)
	throws SchemaException {

		try {
			// TODO : Check if it is a Thread safe method
			final JAXBElement<org.w3._2001.xmlschema.Schema> schemaBinding = getUnMarshaller().unmarshal(
					schemaDescriptorStream, org.w3._2001.xmlschema.Schema.class);

			return schemaBinding.getValue();

		} catch (JAXBException e) {
			throw new SchemaException(
					"Failed to build Java bindings from Schema descriptor XML document", e);
		}
	}




	/**
	 * Get the unmarshaller instance.
	 *
	 * @return the unmarshaller instance
	 * @throws SchemaException
	 *             The exception raised during the unmarshaller creation.
	 */
	public static Unmarshaller getUnMarshaller() throws SchemaException {

		if (unmarshallerCreationEx != null) {
			throw unmarshallerCreationEx;
		}

		return unmarshaller;
	}

	/**
	 * @return the jaxbContext
	 */
	public static JAXBContext getJaxbContext() {
		return SchemaJAXBContext.getJaxbContext();
	}

	public Schema readSchema(URI schemaURI) throws SchemaException {
		Schema desc = null;
		try {
			InputStream input = null;
			File f = new File(schemaURI.getPath());
			if(f.exists()) {
				input = new FileInputStream(f);
			} else {
				input = schemaURI.toURL().openStream();
			}
			desc = readSchema(schemaURI, SourceHelper.convertInputSource2DOMSource(new InputSource(input)));
		} catch (MalformedURLException e) {
			throw new SchemaException("Can not get wsdl at: " + schemaURI, e);
		} catch (IOException e) {
			throw new SchemaException("Can not get wsdl at: " + schemaURI, e);
		} catch (SchemaException e) {
			throw new SchemaException("Can not get wsdl at: " + schemaURI, e);
		} catch (XmlException e) {
			throw new SchemaException("Can not get wsdl at: " + schemaURI, e);
		}
		return desc;
	}




	public Schema readSchema(Document schemaDocument) throws SchemaException {
		Schema desc = null;
		try {
			desc = readSchema(new URI(schemaDocument.getDocumentURI()), new DOMSource(schemaDocument));
		} catch (URISyntaxException e) {
			throw new SchemaException(e);
		}

		return desc;
	}


	public Schema readSchema(URI schemaUri, DOMSource input) throws SchemaException {
		Schema desc = null;
		try {
			DOMSource source1 = SourceHelper.cloneSource(input);
			DOMSource source2 = SourceHelper.cloneSource(input);

			org.w3._2001.xmlschema.Schema def = SchemaReader.convertStream2Schema(source1);
			JDomAnalyzer analyzer = new JDomAnalyzer(SourceHelper.convertDOMSource2InputSource(source2));
			org.jdom.Document doc = analyzer.getDocument();

			
			desc = new com.ebmwebsourcing.commons.schema.impl.Schema(schemaUri, def, doc, this.getFeatures());
		} catch (JDOMException e) {
			throw new SchemaException(e);
		} catch (XmlException e) {
			throw new SchemaException(e);
		} 

		return desc;
	}

}
