/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.impl;

import java.io.StringWriter;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.lang.NotImplementedException;
import org.w3c.dom.Document;

import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.Schema;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class SchemaWriter extends SchemaJAXBContext implements
com.ebmwebsourcing.commons.schema.api.SchemaWriter {

	/**
	 * The JAXB unique marshaller.
	 */
	private static Marshaller marshaller = null;

	/**
	 * The exception raised during JAXB unique marshaller creation.
	 */
	private static SchemaException marshallerCreationEx = null;

	/*
	 * Private object initializations
	 */
	static {
		try {
			SchemaJAXBContext.createContext();
			marshaller = jaxbContext.createMarshaller();
//			marshaller.setSchema(schema);


		} catch (JAXBException e) {
			final SchemaException schemaCreationEx = new SchemaException(
					"Failed to create context", e);

			marshallerCreationEx = new SchemaException(
					"Failed to create the JAXB marshaller",	schemaCreationEx);

		} catch (SchemaException e) {
			final SchemaException schemaCreationEx = new SchemaException(
					"Failed to create context", e);

			marshallerCreationEx = new SchemaException(
					"Failed to create the JAXB marshaller",	schemaCreationEx);

		}
	}


	@SuppressWarnings("unchecked")
	private static Document convertSchema2DOMElement(final org.w3._2001.xmlschema.Schema schemaDescriptor) throws SchemaException {
		Document doc = null;
		try {
			doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

			// TODO : Check if it is a Thread safe method
			JAXBElement element = new JAXBElement( new QName(Constants.SCHEMA_NAMESPACE, Constants.SCHEMA_ROOT_TAG), schemaDescriptor.getClass(), schemaDescriptor);

			marshaller.marshal( element, doc);
		} catch (JAXBException ex) {
			throw new SchemaException(
					"Failed to build XML binding from Schema descriptor Java classes", ex);
		} catch (ParserConfigurationException ex) {
			throw new SchemaException(
					"Failed to build XML binding from Schema descriptor Java classes", ex);

		}
		return doc;
	}

	@SuppressWarnings("unchecked")
	private static String convertSchema2String(final org.w3._2001.xmlschema.Schema schemaDescriptor)
	throws SchemaException {

		try {
			final StringWriter stringWriter = new StringWriter();
			// TODO : Check if it is a Thread safe method

			JAXBElement element = new JAXBElement( new QName(Constants.SCHEMA_NAMESPACE, Constants.SCHEMA_ROOT_TAG), schemaDescriptor.getClass(), schemaDescriptor);

			marshaller.marshal( element, stringWriter);


			return stringWriter.toString();
		} catch (JAXBException e) {
			throw new SchemaException(
					"Failed to build XML binding from Agreement descriptor Java classes", e);
		}
	}

	/**
	 * Get the marshaller instance.
	 *
	 * @return the marshaller instance
	 * @throws SchemaException
	 *             The exception raised during the marshaller creation.
	 */
	public static Marshaller getMarshaller() throws SchemaException {

		if (marshallerCreationEx != null) {
			throw marshallerCreationEx;
		}

		return marshaller;
	}

	public Document getDocument(Schema schemaDef) throws SchemaException {
		Document doc = null;
		if((schemaDef != null)&&(schemaDef instanceof com.ebmwebsourcing.commons.schema.impl.Schema)) {
			try {
				doc = convertSchema2DOMElement((org.w3._2001.xmlschema.Schema) ((com.ebmwebsourcing.commons.schema.impl.Schema)schemaDef).getModel());
				doc.setDocumentURI(schemaDef.getDocumentBaseURI().getPath());
			} catch (SchemaException e) {
				throw new SchemaException("Can not write wsdl description",e);
			}
		}
		return doc;
	}

	public boolean getFeature(String name) throws IllegalArgumentException {
		throw new NotImplementedException();
	}

	public void setFeature(String name, boolean value)
	throws IllegalArgumentException {
		throw new NotImplementedException();
	}

	public String writeSchema(Schema schemaDef) throws SchemaException {
		String res = null;
		if((schemaDef != null)&&(schemaDef instanceof com.ebmwebsourcing.commons.schema.impl.Schema)) {
			try {
				res = convertSchema2String((org.w3._2001.xmlschema.Schema) ((com.ebmwebsourcing.commons.schema.impl.Schema)schemaDef).getModel());
			} catch (SchemaException e) {
				throw new SchemaException("Can not write wsdl description",e);
			}
		}
		return res;
	}

}
