/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.commons.schema.api.Element;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractElement;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractType;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class SimpleType extends AbstractType<org.w3._2001.xmlschema.SimpleType, String> implements
com.ebmwebsourcing.commons.schema.api.SimpleType {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	public SimpleType(org.w3._2001.xmlschema.SimpleType model, Schema schema) {
		super(model, schema);
	}

	public QName getQName() {
		QName res = null;
		if(((org.w3._2001.xmlschema.SimpleType)this.getModel()).getName() != null) {
			res = new QName(this.schema.getTargetNamespace(), ((org.w3._2001.xmlschema.SimpleType)this.getModel()).getName());
		} else {
			res = null;
		}
		return res;
	}

	@Override
	public String printXml(Element eIn, String value) throws SchemaException {
		org.jdom.Element eOut = ((AbstractElement)eIn).generateElement(value);
		return this.outputter.outputString(eOut);
	}

}
