/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.schema.api.abstractElmt;

import com.ebmwebsourcing.commons.schema.api.Include;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.SchemaReader;
import com.ebmwebsourcing.commons.schema.api.XmlException;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractSchema;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractSchemaElement;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractSchemaReader;
import com.ebmwebsourcing.commons.schema.impl.SchemaReader;
import com.ebmwebsourcing.commons.schema.util.SourceHelper;
import com.ebmwebsourcing.commons.schema.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInclude<E>
extends AbstractSchemaElement<E>
implements Include {
    private static Logger log = Logger.getLogger(AbstractInclude.class.getName());
    protected Schema schema;
    protected Schema parent;

    public AbstractInclude(URI baseURI, E model, Map<SchemaReader.FeatureConstants, Object> features) {
        Object obj;
        this.model = model;
        this.parent = null;
        String location = this.getLocationURI();
        if (!Util.isURL(location) && baseURI != null) {
            location = baseURI.getPath() + location;
        }
        if (features != null && ((Boolean)(obj = features.get((Object)SchemaReader.FeatureConstants.IMPORT_DOCUMENTS))).booleanValue()) {
            this.retrieveInclude(location, features);
        }
        if (this.schema != null) {
            ((AbstractSchema)this.schema).setFeatures(features);
        }
    }

    public AbstractInclude(E model, Schema parent) {
        this.model = model;
        this.parent = parent;
        String location = this.getLocationURI();
        if (!Util.isURL(location) && parent.getDocumentBaseURI() != null) {
            location = parent.getDocumentBaseURI().getPath() + location;
        }
        if (this.parent != null && ((AbstractSchema)this.parent).getFeatures() != null && ((Boolean)((AbstractSchema)this.parent).getFeatures().get((Object)SchemaReader.FeatureConstants.IMPORT_DOCUMENTS)).booleanValue()) {
            this.retrieveInclude(location, ((AbstractSchema)this.parent).getFeatures());
        }
        if (parent != null && this.schema != null) {
            ((AbstractSchema)this.schema).setFeatures(((AbstractSchema)this.parent).getFeatures());
        }
    }

    private void retrieveInclude(String location, Map<SchemaReader.FeatureConstants, Object> features) {
        InputStream is = null;
        if (location != null) {
            try {
                URI loc = new URI(location);
                File f = new File(location);
                is = f.exists() ? new FileInputStream(f) : loc.toURL().openStream();
                SchemaReader reader = new SchemaReader();
                ((AbstractSchemaReader)reader).setFeatures(features);
                this.schema = reader.readSchema(loc, SourceHelper.convertInputSource2DOMSource(new InputSource(is)));
            }
            catch (MalformedURLException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (URISyntaxException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (UnknownHostException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (ConnectException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (IOException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (SchemaException e) {
                e.printStackTrace();
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (XmlException e) {
                e.printStackTrace();
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
        }
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getParentSchema() {
        return this.parent;
    }

    public void setParentSchema(Schema parent) {
        this.parent = parent;
    }
}

