/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.schema.api.abstractElmt;

import com.ebmwebsourcing.commons.schema.SchemaFactory;
import com.ebmwebsourcing.commons.schema.api.Attribute;
import com.ebmwebsourcing.commons.schema.api.Element;
import com.ebmwebsourcing.commons.schema.api.Import;
import com.ebmwebsourcing.commons.schema.api.Include;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.SchemaReader;
import com.ebmwebsourcing.commons.schema.api.Type;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractSchemaElement;
import com.ebmwebsourcing.commons.schema.api.extensions.NamespaceContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Document;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchema<E>
extends AbstractSchemaElement<E>
implements Schema {
    private static Logger log = Logger.getLogger(AbstractSchema.class.getName());
    private Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    protected Map<SchemaReader.FeatureConstants, Object> features = new HashMap<SchemaReader.FeatureConstants, Object>();
    protected Document document;
    protected javax.xml.namespace.NamespaceContext namespaceContext;
    protected List<Import> imports = new ArrayList<Import>();
    protected List<Include> includes = new ArrayList<Include>();
    public List<Type> types = new ArrayList<Type>();
    public List<Element> elements = new ArrayList<Element>();
    public List<Attribute> attributes = new ArrayList<Attribute>();
    protected URI baseURI;
    protected Map<String, String> schemaLocations = new HashMap<String, String>();

    public AbstractSchema(URI baseURI, org.w3._2001.xmlschema.Schema schema, Document doc) {
        this.document = doc;
        this.baseURI = baseURI;
        this.namespaceContext = new NamespaceContext();
        List namespaces = this.document.getRootElement().getAdditionalNamespaces();
        for (Namespace ns : namespaces) {
            if ((ns.getPrefix() == null || ns.getPrefix().equals("")) && this.document.getRootElement().getNamespace().getURI().equals(ns.getURI())) {
                ((NamespaceContext)this.namespaceContext).addNamespace(this.document.getRootElement().getNamespace().getPrefix(), this.document.getRootElement().getNamespace().getURI());
                continue;
            }
            ((NamespaceContext)this.namespaceContext).addNamespace(ns.getPrefix(), ns.getURI());
        }
        if (this.document.getRootElement().getAttributeValue("schemaLocation", this.xsi) != null) {
            String val = this.document.getRootElement().getAttributeValue("schemaLocation", this.xsi);
            StringTokenizer st = new StringTokenizer(val, " ");
            String location = null;
            String ns = null;
            while (st.hasMoreTokens()) {
                ns = st.nextToken();
                location = st.hasMoreTokens() ? st.nextToken() : null;
                if (ns != null) {
                    this.schemaLocations.put(ns, location);
                }
                ns = null;
            }
        }
    }

    protected void addImportElementsInAllList() {
        for (Import impt : this.imports) {
            if (impt.getSchema() == null) continue;
            this.types.addAll(impt.getSchema().getTypes());
            this.elements.addAll(impt.getSchema().getElements());
            this.attributes.addAll(impt.getSchema().getAttributes());
        }
    }

    protected void addIncludeElementsInAllList() {
        for (Include incl : this.includes) {
            if (incl.getSchema() == null) continue;
            this.types.addAll(incl.getSchema().getTypes());
            this.elements.addAll(incl.getSchema().getElements());
            this.attributes.addAll(incl.getSchema().getAttributes());
        }
    }

    @Override
    public void addImport(Import impt) {
        if (this.imports == null) {
            this.imports = new ArrayList<Import>();
        }
        this.imports.add(impt);
    }

    @Override
    public List<Import> getImports() {
        if (this.imports == null) {
            this.imports = new ArrayList<Import>();
        }
        return this.imports;
    }

    @Override
    public List<Import> getImports(String namespaceUri) {
        ArrayList<Import> res = new ArrayList<Import>();
        for (Import impt : this.imports) {
            if (!impt.getNamespaceURI().equals(namespaceUri)) continue;
            res.add(impt);
        }
        return res;
    }

    @Override
    public void addInclude(Include incl) throws SchemaException {
        if (this.includes == null) {
            this.includes = new ArrayList<Include>();
        }
        this.includes.add(incl);
    }

    @Override
    public List<Include> getIncludes() {
        if (this.includes == null) {
            this.includes = new ArrayList<Include>();
        }
        return this.includes;
    }

    @Override
    public List<Include> getIncludes(String locationUri) {
        ArrayList<Include> res = new ArrayList<Include>();
        for (Include incl : this.includes) {
            if (!incl.getLocationURI().equals(locationUri)) continue;
            res.add(incl);
        }
        return res;
    }

    @Override
    public List<Type> getTypes() {
        if (this.types == null) {
            this.types = new ArrayList<Type>();
        }
        return this.types;
    }

    @Override
    public Type getType(QName type) {
        Type res = null;
        if (this.types == null) {
            this.types = new ArrayList<Type>();
        }
        for (Type t : this.types) {
            if (!t.getQName().equals(type)) continue;
            res = t;
            break;
        }
        if (res == null && SchemaFactory.getDefaultSchema() != null) {
            for (Type t : SchemaFactory.getDefaultSchema().getTypes()) {
                if (!t.getQName().equals(type)) continue;
                res = t;
                break;
            }
        }
        return res;
    }

    @Override
    public void addType(Type type) {
        if (this.types == null) {
            this.types = new ArrayList<Type>();
        }
        this.types.add(type);
    }

    @Override
    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        return this.attributes;
    }

    @Override
    public Attribute getAttribute(QName element) {
        Attribute res = null;
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        for (Attribute e : this.attributes) {
            if (!e.getName().equals(element.getLocalPart()) || !e.getNamespaceUri().equals(element.getNamespaceURI())) continue;
            res = e;
            break;
        }
        return res;
    }

    @Override
    public void addAttribute(Attribute elmt) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        this.attributes.add(elmt);
    }

    @Override
    public List<Element> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        return this.elements;
    }

    @Override
    public Element getElement(QName element) {
        Element res = null;
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        for (Element e : this.elements) {
            if (!e.getQName().equals(element)) continue;
            res = e;
            break;
        }
        return res;
    }

    @Override
    public void addElement(Element elmt) {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        this.elements.add(elmt);
    }

    @Override
    public javax.xml.namespace.NamespaceContext getAllNamespaces() {
        return this.namespaceContext;
    }

    public Map<SchemaReader.FeatureConstants, Object> getFeatures() {
        if (this.features == null) {
            this.features = new HashMap<SchemaReader.FeatureConstants, Object>();
        }
        return this.features;
    }

    public void setFeatures(Map<SchemaReader.FeatureConstants, Object> features) {
        this.features = features;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public URI getDocumentBaseURI() {
        URI res = null;
        try {
            if (this.baseURI.getPath().lastIndexOf("/") != -1) {
                res = new URI(this.baseURI.getPath().substring(0, this.baseURI.getPath().lastIndexOf("/") + 1));
            }
        }
        catch (URISyntaxException e) {
            log.warning("BaseURI is null : " + this.baseURI);
        }
        return res;
    }

    @Override
    public void setDocumentBaseURI(URI documentBaseURI) {
        this.baseURI = documentBaseURI;
    }

    @Override
    public Map<String, String> getSchemaLocation() {
        return this.schemaLocations;
    }

    public String toString() {
        return this.baseURI.toString();
    }
}

