/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.schema.impl;

import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.XmlException;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractSchemaReader;
import com.ebmwebsourcing.commons.schema.impl.Schema;
import com.ebmwebsourcing.commons.schema.impl.SchemaJAXBContext;
import com.ebmwebsourcing.commons.schema.util.JDomAnalyzer;
import com.ebmwebsourcing.commons.schema.util.SourceHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.xml.sax.InputSource;

public class SchemaReader
extends AbstractSchemaReader
implements com.ebmwebsourcing.commons.schema.api.SchemaReader {
    private static Unmarshaller unmarshaller = null;
    private static SchemaException unmarshallerCreationEx = null;

    private static org.w3._2001.xmlschema.Schema convertStream2Schema(Source schemaDescriptorStream) throws SchemaException {
        try {
            JAXBElement schemaBinding = SchemaReader.getUnMarshaller().unmarshal(schemaDescriptorStream, org.w3._2001.xmlschema.Schema.class);
            return (org.w3._2001.xmlschema.Schema)schemaBinding.getValue();
        }
        catch (JAXBException e) {
            throw new SchemaException("Failed to build Java bindings from Schema descriptor XML document", e);
        }
    }

    public static Unmarshaller getUnMarshaller() throws SchemaException {
        if (unmarshallerCreationEx != null) {
            throw unmarshallerCreationEx;
        }
        return unmarshaller;
    }

    public static JAXBContext getJaxbContext() {
        return SchemaJAXBContext.getJaxbContext();
    }

    public com.ebmwebsourcing.commons.schema.api.Schema readSchema(URI schemaURI) throws SchemaException {
        com.ebmwebsourcing.commons.schema.api.Schema desc = null;
        try {
            InputStream input = null;
            File f = new File(schemaURI.getPath());
            input = f.exists() ? new FileInputStream(f) : schemaURI.toURL().openStream();
            desc = this.readSchema(schemaURI, SourceHelper.convertInputSource2DOMSource(new InputSource(input)));
        }
        catch (MalformedURLException e) {
            throw new SchemaException("Can not get wsdl at: " + schemaURI, e);
        }
        catch (IOException e) {
            throw new SchemaException("Can not get wsdl at: " + schemaURI, e);
        }
        catch (SchemaException e) {
            throw new SchemaException("Can not get wsdl at: " + schemaURI, e);
        }
        catch (XmlException e) {
            throw new SchemaException("Can not get wsdl at: " + schemaURI, e);
        }
        return desc;
    }

    public com.ebmwebsourcing.commons.schema.api.Schema readSchema(org.w3c.dom.Document schemaDocument) throws SchemaException {
        com.ebmwebsourcing.commons.schema.api.Schema desc = null;
        try {
            desc = this.readSchema(new URI(schemaDocument.getDocumentURI()), new DOMSource(schemaDocument));
        }
        catch (URISyntaxException e) {
            throw new SchemaException(e);
        }
        return desc;
    }

    public com.ebmwebsourcing.commons.schema.api.Schema readSchema(URI schemaUri, DOMSource input) throws SchemaException {
        Schema desc = null;
        try {
            DOMSource source1 = SourceHelper.cloneSource(input);
            DOMSource source2 = SourceHelper.cloneSource(input);
            org.w3._2001.xmlschema.Schema def = SchemaReader.convertStream2Schema(source1);
            JDomAnalyzer analyzer = new JDomAnalyzer(SourceHelper.convertDOMSource2InputSource(source2));
            Document doc = analyzer.getDocument();
            desc = new Schema(schemaUri, def, doc, this.getFeatures());
        }
        catch (JDOMException e) {
            throw new SchemaException(e);
        }
        catch (XmlException e) {
            throw new SchemaException(e);
        }
        return desc;
    }

    static {
        try {
            SchemaJAXBContext.createContext();
            unmarshaller = SchemaJAXBContext.getJaxbContext().createUnmarshaller();
        }
        catch (JAXBException e) {
            SchemaException jaxbContextCreationEx = new SchemaException("Failed to create jaxb context", e);
            unmarshallerCreationEx = new SchemaException("Failed to create the JAXB unmarshaller", jaxbContextCreationEx);
        }
        catch (SchemaException e) {
            SchemaException jaxbContextCreationEx = new SchemaException("Failed to create jaxb context", e);
            unmarshallerCreationEx = new SchemaException("Failed to create the JAXB unmarshaller", jaxbContextCreationEx);
        }
    }
}

