/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.server;

import com.ebmwebsourcing.easiergov.WSContainer;
import com.ebmwebsourcing.easiestdemo.helper.BusManagement;
import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.cxf.Server;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;
import com.ebmwebsourcing.eventcloud.mocked.server.EventCloudMocked;
import com.ebmwebsourcing.eventcloud.mocked.util.NotificationConsumerMock;
import com.ebmwebsourcing.seacloud.CEPDeployer.CEPEsperDeployerModule;
import com.ebmwebsourcing.seacloud.client.SeaCloudClientSOAP;
import com.ebmwebsourcing.seacloud.server.SeaCloud;
import com.ebmwebsourcing.seacloud.server.mock.MockDiCEPEImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.config.ConfigurationImpl;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURL;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicSetType;
import engine.cep.admin.api.Action;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.Namespace;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.ow2.petals.notifier.NotificationConsumer_NotifierEndpoint_Server;
import org.w3c.dom.Document;
import seacloud.petalslink.com.data._1.Resource;
import seacloud.petalslink.com.data._1.ResourceType;
import seacloud.petalslink.com.data._1.ResourcesDescriptor;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

public class SeaCloudTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void startServer() throws CloudManagementException {
        SeaCloud adminCloud = null;
        try {
            adminCloud = new SeaCloud("http://localhost:8234/SeaCloudAdmin", null, SeaCloud.CEP_MODE.ESPER, false, false);
            adminCloud.start();
        }
        finally {
            if (adminCloud != null) {
                adminCloud.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartServerWithDescriptor() throws CloudManagementException {
        SeaCloud adminCloud = null;
        try {
            ResourcesDescriptor descriptor = new ResourcesDescriptor();
            Resource esbNode = new Resource();
            esbNode.setAddress("http://localhost:9000/esbExternalAdminEndpoint");
            esbNode.setType(ResourceType.ESB);
            descriptor.getResource().add(esbNode);
            Resource eventCloudNode = new Resource();
            eventCloudNode.setAddress("http://localhost:9100/eventCloudEndpoint");
            eventCloudNode.setType(ResourceType.EVENT_CLOUD);
            descriptor.getResource().add(eventCloudNode);
            Resource bsmNode = new Resource();
            bsmNode.setAddress("http://localhost:9640/bsmExternalAdminEndpoint");
            bsmNode.setType(ResourceType.MONITORING);
            descriptor.getResource().add(bsmNode);
            adminCloud = new SeaCloud("http://localhost:8234/SeaCloudAdmin", descriptor, SeaCloud.CEP_MODE.ESPER, false, false);
            adminCloud.start();
        }
        finally {
            if (adminCloud != null) {
                adminCloud.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddStatementWithActionsUsingEsperModuleTest() throws Exception {
        SeaCloud adminCloud = null;
        try {
            MockDiCEPEImpl dicepeImpl = new MockDiCEPEImpl();
            Server dicepeServer = CXFHelper.getService((String)"http://localhost:9750/services/dicepe", dicepeImpl.getClass(), (Object)dicepeImpl);
            dicepeServer.start();
            WSContainer easiergov = new WSContainer((Configuration)new ConfigurationImpl("localhost", 9738, 9739));
            easiergov.start();
            EventManagerClientImplSOAP easiergovEventClient = new EventManagerClientImplSOAP("http://localhost:9738/services/eventManager");
            PublishTopicNamespaceFromURL request = new PublishTopicNamespaceFromURL();
            request.setTopicNamespaceUrl(Thread.currentThread().getContextClassLoader().getResource("EventTopicNS.xml").toString());
            easiergovEventClient.publishTopicNamespaceFromURL(request);
            ResourcesDescriptor descriptor = new ResourcesDescriptor();
            Resource govNode = new Resource();
            govNode.setAddress("http://localhost:9738/services/eventManager");
            govNode.setType(ResourceType.GOVERNANCE);
            descriptor.getResource().add(govNode);
            Resource dicepe = new Resource();
            dicepe.setAddress("http://localhost:9750/services/dicepe");
            dicepe.setType(ResourceType.CEP_ENGINE);
            descriptor.getResource().add(dicepe);
            Resource eventCloudNode = new Resource();
            eventCloudNode.setAddress("http://localhost:9100/eventCloudEndpoint");
            eventCloudNode.setType(ResourceType.EVENT_CLOUD);
            descriptor.getResource().add(eventCloudNode);
            adminCloud = new SeaCloud("http://localhost:8234/SeaCloudAdmin", descriptor, SeaCloud.CEP_MODE.ESPER, false, false);
            adminCloud.start();
            SeaCloudClientSOAP seaCloudClient = new SeaCloudClientSOAP("http://localhost:8234/SeaCloudAdmin");
            AddStatementWithActions req = new AddStatementWithActions();
            req.setStatementId(UUID.randomUUID().toString());
            req.setStatement("select * from offerEvent.win:keepall() as driver, offerEvent.win:keepall() as truck, demandEvent.win:keepall() as demand where driver.Type='driver' And truck.Type='truck' And demand.Type='truck with driver' And demand.Quantity<=driver.Quantity and demand.Quantity<=truck.Quantity");
            ArrayList<Namespace> namespaceOfEventTypes = new ArrayList<Namespace>();
            Namespace nsOfferEvent = new Namespace();
            nsOfferEvent.setPrefix("data");
            nsOfferEvent.setNamespace("http://www.mines-albi.fr/nuclearcrisisevent");
            nsOfferEvent.setEventTypeName("offerEvent");
            namespaceOfEventTypes.add(nsOfferEvent);
            Namespace nsDemandEvent = new Namespace();
            nsDemandEvent.setPrefix("data");
            nsDemandEvent.setNamespace("http://www.mines-albi.fr/nuclearcrisisevent");
            nsDemandEvent.setEventTypeName("demandEvent");
            namespaceOfEventTypes.add(nsDemandEvent);
            req.getNamespaceOfEventTypes().addAll(namespaceOfEventTypes);
            Action a = new Action();
            a.setName(new QName("http://www.mines-albi.fr/nuclearcrisisevent", "resourcesStatusEvent"));
            a.setType("event");
            Action.Fields.Entry e = new Action.Fields.Entry();
            e.setKey("resourcesStatusEvent.Quantity");
            e.setValue("offerEvent.Quantity");
            a.setFields(new Action.Fields());
            a.getFields().getEntry().add(e);
            req.getAction().add(a);
            AddStatementResponseWithActions res = seaCloudClient.addStatementWithActions(req);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((String)"cool!!!", (String)res.getResponse());
        }
        finally {
            if (adminCloud != null) {
                adminCloud.stop();
            }
        }
        CEPEsperDeployerModule module = new CEPEsperDeployerModule(new ArrayList(), null, new URL("http://localhost:9738/services/eventManager"));
        ArrayList<QName> primitivesEvent = new ArrayList<QName>();
        primitivesEvent.add(new QName("http://www.mines-albi.fr/nuclearcrisisevent", "offerEvent"));
        primitivesEvent.add(new QName("http://www.mines-albi.fr/nuclearcrisisevent", "demandEvent"));
        Map topics = module.findCorrespondingTopicsFromPrimitivesEvents(primitivesEvent);
        Assert.assertEquals((int)2, (int)topics.size());
        Assert.assertEquals((String)"{http://www.petalslink.org/EventCloud/}resourcesEvent", (String)((QName)topics.values().iterator().next()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void subscribeOnEventCloudMockedUsingSeaCloudTest() throws Exception {
        EventCloudMocked eventcloud = null;
        SeaCloud seaCloud = null;
        Node node = null;
        try {
            EJaxbTopicSetType tps = (EJaxbTopicSetType)SOAJAXBContext.getInstance().marshallAnyType(DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(Thread.currentThread().getContextClassLoader().getResource("EventTopicSet.xml").openStream()), EJaxbTopicSetType.class);
            eventcloud = new EventCloudMocked("http://localhost:9666/EventCloud", false);
            eventcloud.start();
            node = BusManagement.getInstance().createNode(new QName("http://www.petalslink.org", "EasyESB"), "localhost", 9000, 8084);
            node.start();
            ResourcesDescriptor descriptor = new ResourcesDescriptor();
            Resource govNode = new Resource();
            govNode.setAddress("http://localhost:9738/services/eventManager");
            govNode.setType(ResourceType.GOVERNANCE);
            descriptor.getResource().add(govNode);
            Resource eventCloudNode = new Resource();
            eventCloudNode.setAddress("http://localhost:9666/EventCloud");
            eventCloudNode.setType(ResourceType.EVENT_CLOUD);
            descriptor.getResource().add(eventCloudNode);
            Resource esbNode = new Resource();
            esbNode.setAddress("http://localhost:8084/services/adminExternalEndpoint");
            esbNode.setType(ResourceType.ESB);
            descriptor.getResource().add(esbNode);
            seaCloud = new SeaCloud("http://localhost:8234/SeaCloudAdmin", descriptor, SeaCloud.CEP_MODE.ESPER, true, true);
            seaCloud.start();
            SeaCloudClientSOAP seaCloudClient = new SeaCloudClientSOAP("http://localhost:8234/SeaCloudAdmin");
            Subscribe payload = WSNHelper.createSubscription((String)"http://subscriptionClient.com/", (QName)new QName("http://www.petalslink.org/EventCloud/", "situationalMeasureEventTopic", "res"), (QName[])new QName[0]);
            Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload);
            EJaxbSubscribeResponse response = seaCloudClient.subscribe(doc);
            Assert.assertNotNull((Object)response);
        }
        finally {
            if (seaCloud != null) {
                seaCloud.stop();
            }
            if (eventcloud != null) {
                eventcloud.stop();
            }
            if (node != null) {
                node.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void notifyOnEventCloudMockedUsingSeaCloudTest() throws Exception {
        EventCloudMocked eventcloud = null;
        SeaCloud seaCloud = null;
        Node node = null;
        NotificationConsumer_NotifierEndpoint_Server notifServer = null;
        try {
            EJaxbTopicSetType tps = (EJaxbTopicSetType)SOAJAXBContext.getInstance().marshallAnyType(DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(Thread.currentThread().getContextClassLoader().getResource("EventTopicSet.xml").openStream()), EJaxbTopicSetType.class);
            eventcloud = new EventCloudMocked("http://localhost:9666/EventCloud", false);
            eventcloud.start();
            node = BusManagement.getInstance().createNode(new QName("http://www.petalslink.org", "EasyESB"), "localhost", 9000, 8084);
            node.start();
            ResourcesDescriptor descriptor = new ResourcesDescriptor();
            Resource govNode = new Resource();
            govNode.setAddress("http://localhost:9738/services/eventManager");
            govNode.setType(ResourceType.GOVERNANCE);
            descriptor.getResource().add(govNode);
            Resource eventCloudNode = new Resource();
            eventCloudNode.setAddress("http://localhost:9666/EventCloud");
            eventCloudNode.setType(ResourceType.EVENT_CLOUD);
            descriptor.getResource().add(eventCloudNode);
            Resource esbNode = new Resource();
            esbNode.setAddress("http://localhost:8084/services/adminExternalEndpoint");
            esbNode.setType(ResourceType.ESB);
            descriptor.getResource().add(esbNode);
            seaCloud = new SeaCloud("http://localhost:8234/SeaCloudAdmin", descriptor, SeaCloud.CEP_MODE.ESPER, true, true);
            seaCloud.start();
            SeaCloudClientSOAP seaCloudClient = new SeaCloudClientSOAP("http://localhost:8234/SeaCloudAdmin");
            Subscribe payload = WSNHelper.createSubscription((String)"http://localhost:9601/BusConsumerService", (QName)new QName("http://www.petalslink.org/EventCloud/", "situationalMeasureEventTopic", "res"), (QName[])new QName[0]);
            Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload);
            EJaxbSubscribeResponse response = seaCloudClient.subscribe(doc);
            Assert.assertNotNull((Object)response);
            String busNotifConsumerAddress = "http://localhost:9601/BusConsumerService";
            NotificationConsumerMock notifier = new NotificationConsumerMock();
            notifServer = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notifier, busNotifConsumerAddress);
            Document content = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream("<text>Hello World</text>".getBytes()));
            Notify notify = WSNHelper.createNotification((String)"http://localhost:9601/BusConsumerService", (String)"http://subscriptionProducer.com/", (QName)new QName("http://www.petalslink.org/EventCloud/", "situationalMeasureEventTopic", "res"), (Object)content);
            doc = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
            seaCloudClient.notify(doc);
            while (notifier.getNotifications().size() == 0) {
                Thread.sleep(200L);
            }
            Assert.assertEquals((int)1, (int)notifier.getNotifications().size());
        }
        finally {
            if (seaCloud != null) {
                seaCloud.stop();
            }
            if (eventcloud != null) {
                eventcloud.stop();
            }
            if (node != null) {
                node.stop();
            }
            if (notifServer != null) {
                notifServer.shutdown();
            }
        }
    }
}

