/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.seacloud.server.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.LogManager;

import seacloud.petalslink.com.data._1.ResourcesDescriptor;

import com.ebmwebsourcing.seacloud.launcher.SeaCloudWithEtalisLauncher;
import com.ebmwebsourcing.seacloud.launcher.util.CommandReader;
import com.ebmwebsourcing.seacloud.launcher.util.Locker;
import com.ebmwebsourcing.seacloud.launcher.util.SystemExitHook;
import com.ebmwebsourcing.seacloud.server.SeaCloud;
import com.ebmwebsourcing.seacloud.server.SeaCloudUI;

/**
 * 
 * Created on 29 janv. 08
 * 
 * @author Christophe HAMERLING, Roland Naudin - eBM WebSourcing
 * @since 1.0
 * 
 */
public class SeaCloudUIWithEtalisLauncher extends SeaCloudWithEtalisLauncher {


	static {
		try {
			InputStream inputStream = null;
			File logger = new File("." + LOGGER_FILE);
			if (logger.exists()) {
				inputStream = new FileInputStream(logger);
			} else {
				// ty to get from classpath
				inputStream = SeaCloudUIWithEsperLauncher.class.getClass()
						.getResourceAsStream(LOGGER_FILE);
			}
			if (inputStream != null) {
				LogManager.getLogManager().readConfiguration(inputStream);
				inputStream.close();
			}
		} catch (final Exception e) {
			throw new RuntimeException("couldn't initialize logging properly",
					e);
		}
	}


	private SeaCloudUI serverUI;

	/*
	 * (non-Javadoc)
	 * 
	 */
	public void start() throws Exception {
		// check if started or not stopped correctly
		if (this.locker.isLocked()) {
			throw new Exception(
					"Can not start the SeaCloud server, remove lock file from SeaCloud root path or stop server");
		}

		this.locker.lock();

		Configuration conf = new ConfigurationImpl();
		
		String host = conf.getHost();
		int port = conf.getPort();
		
		if(host == null || port <= 0) {
			throw new Exception("Wrong host or port parameters!!!");
		}
		
		String seaCloudServerAddress = "http://" + host + ":" + port + "/SeaCloudAdmin";
		ResourcesDescriptor descriptor = null;//SeaCloudUI.readDescriptor(Thread.currentThread().getContextClassLoader().getResource("descriptor.xml").toURI().toURL());

		this.serverUI = new SeaCloudUI(seaCloudServerAddress, SeaCloud.CEP_MODE.ESPER, descriptor, false, useCepMock, useEventCloudMock);	
		this.serverUI.refreshAll();
		this.serverUI.setVisible(true);
		
		this.server = this.serverUI.getServer();
		System.out.println("SeaCloud with Esper started at: " + "http://" + host + ":" + port + "/SeaCloudAdmin");
		
		// add a hook if a terminate signal is sent from the command
		// line
		this.systemExitHook = new SystemExitHook(this.locker);
		Runtime.getRuntime().addShutdownHook(this.systemExitHook);

	}

	
}
