package com.ebmwebsourcing.seacloud.server.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.impl.wsdl11.DescriptionImpl;
import org.petalslink.easiestdemo.client.model.api.gov.ProvidedService;
import org.petalslink.easiestdemo.client.util.SpecificClasspathURIResolver;

import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.URIMultipleResolvers;
import com.ebmwebsourcing.seacloud.server.SeaCloudRegistry;

public class CepNode {


	private List<ProvidedService> providedServices = new ArrayList<ProvidedService>();

	private SeaCloudRegistry registry = null;

	private String address = null;

	private QName name = null;


	public CepNode(String address, SeaCloudRegistry registry) throws SOAPException {
		this.address = address;
		this.registry = registry;

		this.init(this.address);

	}

	private void init(String address) throws SOAPException {
		this.name = new QName("http://research.petalslink.com", "DiCEPe");

	}

	public QName getQName() {
		return this.name;
	}

	public List<ProvidedService> getProvidedServices() {
		return providedServices;
	}


	public String toString() {
		return this.getQName().getLocalPart();
	}


	public ProvidedService findProvidedService(String name) {
		ProvidedService res = null;
		for(ProvidedService ps: this.providedServices) {
			if(ps.getName().getLocalPart().equals(name)) {
				res = ps;
				break;
			}
		}
		return res;
	}

}
