/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.server.model;

import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.seacloud.server.SeaCloudRegistry;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Service;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.gov.ProvidedService;
import org.petalslink.easiestdemo.client.model.impl.gov.ProvidedServiceImpl;

public class SeaCloudNode {
    private List<Node> connectedNodes = new ArrayList<Node>();
    private List<ProvidedService> providedServices = new ArrayList<ProvidedService>();
    private SeaCloudRegistry registry = null;
    private String address = null;
    private QName name = null;

    public SeaCloudNode(String address, SeaCloudRegistry registry) throws SOAPException {
        this.address = address;
        this.registry = registry;
        this.init(this.address);
    }

    private void init(String address) throws SOAPException {
        this.name = new QName("http://research.petalslink.com", "SeaCloud");
        try {
            URL seaCloud = new URL(address + "?wsdl");
            Definitions def = (Definitions)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasiestDEMOFramework.getInstance()).get()).readDocument(seaCloud, Definitions.class);
            Description desc = (Description)Factory.getInstance().wrap((XmlObject)def);
            this.providedServices.clear();
            this.providedServices.add((ProvidedService)new ProvidedServiceImpl(new QName(def.getServices()[0].inferQName().getNamespaceURI(), def.getServices()[0].getPorts()[0].getName()), ((Service)desc.getServices().iterator().next()).getEndpoints()[0], (Service)desc.getServices().iterator().next()));
        }
        catch (Throwable e) {
            throw new SOAPException(e.getMessage(), e);
        }
    }

    public QName getQName() {
        return this.name;
    }

    public List<ProvidedService> getProvidedServices() {
        return this.providedServices;
    }

    public String toString() {
        return this.getQName().getLocalPart();
    }

    public List<Node> getConnectedNodes() throws WSOUIClientException {
        return this.connectedNodes;
    }

    public void refreshConnectedNodes() throws WSOUIClientException {
    }

    public ProvidedService findProvidedService(String name) {
        ProvidedService res = null;
        for (ProvidedService ps : this.providedServices) {
            if (!ps.getName().getLocalPart().equals(name)) continue;
            res = ps;
            break;
        }
        return res;
    }
}

