/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.CEPDeployer;

import com.ebmwebsourcing.easiergov.WSContainer;
import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;
import com.ebmwebsourcing.seacloud.CEPDeployer.CEPEsperDeployerModule;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.config.ConfigurationImpl;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURL;
import com.petalslink.events_api._1_0.PublishTopicNamespaceFromURLFault;
import engine.cep.admin.api.Namespace;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

public class CEPEsperDeployerModuleTest {
    @Test
    public void decomposeRuleTest() throws CloudManagementException, MalformedURLException {
        CEPEsperDeployerModule module = new CEPEsperDeployerModule(new ArrayList(), null, new URL("http://localhost:9738/services/eventManager"));
        String rule = "select * from offerEvent.win:keepall() as driver, offerEvent.win:keepall() as truck, demandEvent.win:keepall() as demand where driver.Type='driver' And truck.Type='truck' And demand.Type='truck with driver' And demand.Quantity<=driver.Quantity and demand.Quantity<=truck.Quantity";
        ArrayList<Namespace> namespaceOfEventTypes = new ArrayList<Namespace>();
        Namespace nsOfferEvent = new Namespace();
        nsOfferEvent.setPrefix("data");
        nsOfferEvent.setNamespace("http://www.mines-albi.fr/nuclearcrisisevent");
        nsOfferEvent.setEventTypeName("offerEvent");
        namespaceOfEventTypes.add(nsOfferEvent);
        Namespace nsDemandEvent = new Namespace();
        nsDemandEvent.setPrefix("data");
        nsDemandEvent.setNamespace("http://www.mines-albi.fr/nuclearcrisisevent");
        nsDemandEvent.setEventTypeName("demandEvent");
        namespaceOfEventTypes.add(nsDemandEvent);
        List primitivesEvent = module.findPrimitiveEventsInRule(rule, namespaceOfEventTypes);
        Assert.assertEquals((int)2, (int)primitivesEvent.size());
        Assert.assertEquals((String)"{http://www.mines-albi.fr/nuclearcrisisevent}offerEvent", (String)((QName)primitivesEvent.get(0)).toString());
        Assert.assertEquals((String)"{http://www.mines-albi.fr/nuclearcrisisevent}demandEvent", (String)((QName)primitivesEvent.get(1)).toString());
    }

    @Test
    public void findTopicTest() throws CloudManagementException, GovException, MalformedURLException, PublishTopicNamespaceFromURLFault {
        WSContainer easiergov = new WSContainer((Configuration)new ConfigurationImpl("localhost", 9738, 9739));
        easiergov.start();
        EventManagerClientImplSOAP easiergovEventClient = new EventManagerClientImplSOAP("http://localhost:9738/services/eventManager");
        PublishTopicNamespaceFromURL request = new PublishTopicNamespaceFromURL();
        request.setTopicNamespaceUrl(Thread.currentThread().getContextClassLoader().getResource("EventTopicNS.xml").toString());
        easiergovEventClient.publishTopicNamespaceFromURL(request);
        CEPEsperDeployerModule module = new CEPEsperDeployerModule(new ArrayList(), null, new URL("http://localhost:9738/services/eventManager"));
        ArrayList<QName> primitivesEvent = new ArrayList<QName>();
        primitivesEvent.add(new QName("http://www.mines-albi.fr/nuclearcrisisevent", "offerEvent"));
        primitivesEvent.add(new QName("http://www.mines-albi.fr/nuclearcrisisevent", "demandEvent"));
        Map topics = module.findCorrespondingTopicsFromPrimitivesEvents(primitivesEvent);
        Assert.assertEquals((int)2, (int)topics.size());
        Assert.assertEquals((String)"{http://www.petalslink.org/EventCloud/}resourcesEventTopic", (String)((QName)topics.values().iterator().next()).toString());
    }
}

