package com.ebmwebsourcing.seacloud.pubsub;

import java.net.URL;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;

import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;
import com.ebmwebsourcing.seacloud.model.AbstractModule;
import com.ebmwebsourcing.seacloud.model.PubSubModule;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;

public class ESBPubSubModule extends AbstractModule implements PubSubModule {

	private UserManagementClientSOAP client = null;
	
	private static final Logger LOG = Logger.getLogger(ESBPubSubModule.class.getName());
	
	public ESBPubSubModule(List<URL> adminAdresses)
			throws CloudManagementException {
		super(adminAdresses);

		if(this.externalComponentAdresses.size() > 0) {
			this.client = new UserManagementClientSOAP(this.externalComponentAdresses.get(0).toString());
		}
	}

	/**
	 * @return the clientProxy
	 */
	private synchronized UserManagementClientSOAP getClientProxy() {
		return this.client;
	}

	@Override
	public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest)
			throws UnrecognizedPolicyRequestFault, InvalidTopicExpressionFault,
			UnacceptableInitialTerminationTimeFault,
			NotifyMessageNotSupportedFault, TopicNotSupportedFault,
			InvalidMessageContentExpressionFault,
			TopicExpressionDialectUnknownFault, ResourceUnknownFault,
			UnsupportedPolicyRequestFault, InvalidFilterFault,
			SubscribeCreationFailedFault,
			InvalidProducerPropertiesExpressionFault {
		try {
			LOG.info("SEACLOUD ESB => Subscribe: " + XMLPrettyPrinter.prettyPrint(SOAJAXBContext.getInstance().unmarshallAnyElement(subscribeRequest)));
		} catch (SOAException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return this.getClientProxy().subscribe(subscribeRequest);
	}

	@Override
	public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribeRequest)
			throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
		return this.getClientProxy().unsubscribe(unsubscribeRequest);
	}

	@Override
	public void notify(EJaxbNotify notify) {
		this.getClientProxy().notify(notify);
	}

	@Override
	public EJaxbGetResourcePropertyResponse getResourceProperty(
			QName getResourcePropertyRequest) throws ResourceUnavailableFault,
			ResourceUnknownFault, InvalidResourcePropertyQNameFault {
		return this.getClientProxy().getResourceProperty(getResourcePropertyRequest);
	}

}
