/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.eventcloud.mocked.launcher.util;

import com.ebmwebsourcing.eventcloud.mocked.launcher.tasks.InfoTask;
import com.ebmwebsourcing.eventcloud.mocked.launcher.tasks.ShutdownTask;
import com.ebmwebsourcing.eventcloud.mocked.launcher.tasks.Task;
import com.ebmwebsourcing.eventcloud.mocked.server.EventCloudMocked;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class CommandReader {
    protected File currentPath;
    SortedMap<String, Task> map = new TreeMap<String, Task>();

    public CommandReader(EventCloudMocked node) {
        this.addCommand(new InfoTask(node));
        this.addCommand(new ShutdownTask());
    }

    private void addCommand(Task command) {
        this.map.put(command.getShortcut(), command);
    }

    public void read() {
        System.out.println("EventCloud prompt. Tape 'h' for help.");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        int code = 1;
        while (code > 0) {
            try {
                System.out.println();
                System.out.print("eventCloud@localhost:/> ");
                code = this.processCommandLine(br.readLine());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected int processCommandLine(String command) {
        int result = 1;
        if (command != null && command.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(command, " ");
            ArrayList<String> args = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                args.add(tokenizer.nextToken());
            }
            String key = (String)args.get(0);
            if ("h".equalsIgnoreCase(key) || "help".equalsIgnoreCase(key)) {
                this.printUsage();
            } else {
                Task task = this.getTask(key);
                if (task == null) {
                    System.out.println("Unrecognized command : " + command + " (type 'h' for help)");
                } else {
                    List arguments = null;
                    arguments = args.size() > 1 ? args.subList(1, args.size()) : new ArrayList(0);
                    result = task.process(arguments);
                    if (result == -2) {
                        System.out.println("Bad arguments : " + arguments + " (type 'h' for help)");
                        result = 1;
                    }
                }
            }
        }
        return result;
    }

    private void printUsage() {
        System.out.println("Event Cloud prompt usage:");
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            Task command = (Task)this.map.get(iter.next());
            System.out.println(" - " + command.toString());
        }
    }

    private Task getTask(String command) {
        String shortcut;
        Task task = (Task)this.map.get(command);
        if (task == null && (shortcut = this.getShortcutFromCommand(command)) != null) {
            task = (Task)this.map.get(shortcut);
        }
        return task;
    }

    private String getShortcutFromCommand(String command) {
        String result = null;
        boolean found = false;
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext() && !found) {
            Task task = (Task)this.map.get(iter.next());
            if (!command.equals(task.getName())) continue;
            result = task.getShortcut();
            found = true;
        }
        return result;
    }
}

