/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.pubsub;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.seacloud.pubsub.EventCloudPubSubModule;
import com.ebmwebsourcing.seacloud.pubsub.NotificationConsumerDecoratorImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.implementor.WsrfbfModelFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.WsrfbfModelFactoryImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.implementor.WsrfrModelFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.impl.impl.WsrfrModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.implementor.WsrfrlModelFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl.WsrfrlModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.implementor.WsrfrpModelFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl.WsrfrpModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;
import fr.inria.eventcloud.deployment.cli.launchers.EventCloudsManagementServiceDeployer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.ow2.petals.notifier.NotificationConsumer_NotifierEndpoint_Server;
import org.w3c.dom.Document;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

public class EventCloudPubSubModuleTest {
    private static final String EVENTCLOUD_ACTIVATE_LOGGERS_PROPERTY_NAME = "eventcloud.activate.loggers";
    private static final int EVENTCLOUD_WS_PORT = 8888;
    private static final int NOTIFICATION_CONSUMER_PORT = 8889;
    public EventCloudPubSubModule module;

    @Before
    public void init() throws Exception {
        try {
            boolean activateLoggers = System.getProperty(EVENTCLOUD_ACTIVATE_LOGGERS_PROPERTY_NAME) != null ? Boolean.parseBoolean(System.getProperty(EVENTCLOUD_ACTIVATE_LOGGERS_PROPERTY_NAME)) : true;
            String eventCloudsManagementWsEndpoint = EventCloudsManagementServiceDeployer.deploy((boolean)false, (int)8888, (String)"EventCloudsManagementService", (boolean)activateLoggers);
            ArrayList<URL> adminAdresses = new ArrayList<URL>(1);
            adminAdresses.add(new URL(eventCloudsManagementWsEndpoint));
            this.module = new EventCloudPubSubModule(adminAdresses);
        }
        catch (IOException ioe) {
            throw new CloudManagementException("Cannot launch the Event Cloud management web service", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testPubSub() throws Exception {
        StringBuilder notificationConsumerAddressBuilder = new StringBuilder("http://");
        try {
            notificationConsumerAddressBuilder.append(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        notificationConsumerAddressBuilder.append(":");
        notificationConsumerAddressBuilder.append(8889);
        notificationConsumerAddressBuilder.append("/consumer");
        String notificationConsumerAddress = notificationConsumerAddressBuilder.toString();
        NotificationConsumerDecoratorImpl notificationConsumerDecoratorImpl = new NotificationConsumerDecoratorImpl();
        NotificationConsumer_NotifierEndpoint_Server notificationConsumerNes = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notificationConsumerDecoratorImpl, notificationConsumerAddress);
        String topicNamespace = "http://www.petalslink.org/EventCloud/";
        String topicPrefix = "res";
        String topicLocalPart = "resourcesEventTopic";
        QName topic = new QName(topicNamespace, topicLocalPart, topicPrefix);
        Subscribe subscribeRequest = WSNHelper.createSubscription((String)notificationConsumerAddress, (QName)topic, (QName[])new QName[0]);
        EJaxbSubscribe convertedSubscribeRequest = WSNHelper.convert2JaxbElement((Subscribe)subscribeRequest);
        this.module.subscribe(convertedSubscribeRequest);
        Thread.sleep(2000L);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = factory.newDocumentBuilder().parse(EventCloudPubSubModuleTest.class.getResourceAsStream("/notification.xml"));
        Notify notify = Wsnb4ServUtils.getWsnbReader().readNotify(document);
        EJaxbNotify convertedNotify = WSNHelper.convert2JaxbElement((Notify)notify);
        this.module.notify(convertedNotify);
        List<EJaxbNotify> list = notificationConsumerDecoratorImpl.notifiesReceived;
        synchronized (list) {
            while (notificationConsumerDecoratorImpl.notifiesReceived.size() != 1) {
                notificationConsumerDecoratorImpl.notifiesReceived.wait();
            }
        }
        notificationConsumerNes.shutdown();
    }

    @After
    public void tearDown() throws Exception {
        this.module.cleanup();
        EventCloudsManagementServiceDeployer.destroy();
    }

    static {
        Wsnb4ServUtils.initModelFactories((WsrfbfModelFactory)new WsrfbfModelFactoryImpl(), (WsrfrModelFactory)new WsrfrModelFactoryImpl(), (WsrfrlModelFactory)new WsrfrlModelFactoryImpl(), (WsrfrpModelFactory)new WsrfrpModelFactoryImpl(), (WstopModelFactory)new WstopModelFactoryImpl(), (WsnbModelFactory)new WsnbModelFactoryImpl());
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class, easybox.org.oasis_open.docs.wsn.t_1.ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

