/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.pubsub;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;
import com.ebmwebsourcing.seacloud.model.AbstractModule;
import com.ebmwebsourcing.seacloud.model.PubSubModule;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbFilterType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbTopicExpressionType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import fr.inria.eventcloud.webservices.api.EventCloudsManagementWsApi;
import fr.inria.eventcloud.webservices.factories.WsClientFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.cxf.frontend.ClientProxy;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

public class EventCloudPubSubModule
extends AbstractModule
implements PubSubModule {
    private static final Logger LOG = Logger.getLogger(EventCloudPubSubModule.class.getName());
    private String eventCloudsManagementWsEndpoint;
    private EventCloudsManagementWsApi eventCloudsManagementWsClient;
    private Set<QName> topics;
    private Map<QName, String> subscribeProxies;
    private Map<QName, String> publishProxies;
    private boolean initialized;

    public EventCloudPubSubModule(List<URL> adminAddresses) throws CloudManagementException {
        super(adminAddresses);
        if (this.externalComponentAdresses.size() <= 0) {
            throw new CloudManagementException("Cannot start EventCloudPubSubModule because no Event Clouds management web service endpoint has been given");
        }
        this.eventCloudsManagementWsEndpoint = ((URL)this.externalComponentAdresses.get(0)).toString();
        this.initialized = false;
        this.init();
    }

    public void init() {
        if (this.initialized) {
            this.cleanup();
        }
        this.eventCloudsManagementWsClient = (EventCloudsManagementWsApi)WsClientFactory.createWsClient(EventCloudsManagementWsApi.class, (String)this.eventCloudsManagementWsEndpoint);
        this.topics = new HashSet<QName>();
        this.subscribeProxies = new HashMap<QName, String>();
        this.publishProxies = new HashMap<QName, String>();
        this.initialized = true;
    }

    public void destroyEventCloud(QName topic) {
        this.eventCloudsManagementWsClient.destroyEventCloud(topic.toString());
        this.topics.remove(topic);
        this.subscribeProxies.remove(topic);
        this.publishProxies.remove(topic);
    }

    public void destroyEventClouds() {
        for (QName topic : this.topics) {
            this.destroyEventCloud(topic);
        }
    }

    public void cleanup() {
        if (this.initialized) {
            this.destroyEventClouds();
            ClientProxy.getClient((Object)this.eventCloudsManagementWsClient).destroy();
            this.eventCloudsManagementWsClient = null;
            this.initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest) throws UnrecognizedPolicyRequestFault, InvalidTopicExpressionFault, UnacceptableInitialTerminationTimeFault, NotifyMessageNotSupportedFault, TopicNotSupportedFault, InvalidMessageContentExpressionFault, TopicExpressionDialectUnknownFault, ResourceUnknownFault, UnsupportedPolicyRequestFault, InvalidFilterFault, SubscribeCreationFailedFault, InvalidProducerPropertiesExpressionFault {
        try {
            if (this.initialized) {
                QName topic = WSNHelper.getQNameInSimpleTopicExpression((TopicExpressionType)WSNHelper.getTopicExpressionInFilter((EJaxbFilterType)subscribeRequest.getFilter()));
                LOG.info("Received subscription on topic : " + topic.getNamespaceURI() + topic.getLocalPart());
                Set<QName> set = this.topics;
                synchronized (set) {
                    this.createEventCloudIfNotExist(topic);
                    if (!this.subscribeProxies.containsKey(topic)) {
                        this.subscribeProxies.put(topic, this.eventCloudsManagementWsClient.deploySubscribeWsnService(topic.getNamespaceURI() + topic.getLocalPart()));
                        LOG.info("New subscribe proxy for topic " + topic.getNamespaceURI() + topic.getLocalPart() + " created");
                    }
                }
                UserManagementClientSOAP client = new UserManagementClientSOAP(this.subscribeProxies.get(topic) + "?wsdl");
                return client.subscribe(subscribeRequest);
            }
            return new EJaxbSubscribeResponse();
        }
        catch (WsnbException e) {
            throw new InvalidTopicExpressionFault(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(EJaxbNotify notify) {
        block7: {
            try {
                if (!this.initialized) break block7;
                System.out.println("%%%% notify: \n" + XMLPrettyPrinter.prettyPrint((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notify)));
                QName topic = EventCloudPubSubModule.getQNameInSimpleTopicExpression(((EJaxbNotificationMessageHolderType)notify.getNotificationMessage().get(0)).getTopic());
                LOG.info("Received notification on topic : " + topic.getNamespaceURI() + topic.getLocalPart());
                Set<QName> set = this.topics;
                synchronized (set) {
                    this.createEventCloudIfNotExist(topic);
                    if (!this.publishProxies.containsKey(topic)) {
                        this.publishProxies.put(topic, this.eventCloudsManagementWsClient.deployPublishWsnService(topic.getNamespaceURI() + topic.getLocalPart()));
                        LOG.info("New publish proxy for topic " + topic.getNamespaceURI() + topic.getLocalPart() + " created");
                    }
                }
                this.sendNotify(notify, this.publishProxies.get(topic));
            }
            catch (WsnbException e) {
                e.printStackTrace();
            }
            catch (SOAException e) {
                e.printStackTrace();
            }
        }
    }

    public static QName getQNameInSimpleTopicExpression(EJaxbTopicExpressionType topicItem) throws WsnbException {
        QName currentTopic = null;
        Object content = EventCloudPubSubModule.getObjectInList(topicItem.getContent());
        System.out.println("%%%%%%%%%%%%%%% content = " + content);
        if (content instanceof Element) {
            Element elmt = (Element)content;
            String value = ((Text)elmt.getFirstChild()).getTextContent();
            if (value.indexOf(":") > 0 && value.trim().split(":").length > 0) {
                String prefix = value.trim().split(":")[0];
                String localpart = value.trim().split(":")[1];
                String xmlns = elmt.getAttribute("xmlns:" + prefix);
                currentTopic = new QName(xmlns, localpart, prefix);
            } else if (elmt.getAttribute("xmlns") != null) {
                String xmlns = elmt.getAttribute("xmlns");
                currentTopic = new QName(xmlns, value.trim());
            } else {
                currentTopic = new QName(value.trim());
            }
            System.out.println("currentTopic = " + currentTopic);
        } else if (content instanceof JAXBElement) {
            JAXBElement jelmt = (JAXBElement)content;
            System.out.println("%%%%%% value = " + jelmt.getValue());
            if (jelmt.getValue() instanceof QName) {
                currentTopic = (QName)jelmt.getValue();
            }
        } else {
            throw new WsnbException("TopicExpression type not supported here");
        }
        return currentTopic;
    }

    private static Object getObjectInList(List<?> list) {
        System.out.println("%%%%%%%%%% list = " + list);
        for (Object obj : list) {
            if (obj == null || obj instanceof String) continue;
            return obj;
        }
        return null;
    }

    private void createEventCloudIfNotExist(QName topic) {
        if (!this.topics.contains(topic)) {
            this.eventCloudsManagementWsClient.createEventCloud(topic.getNamespaceURI() + topic.getLocalPart());
            this.topics.add(topic);
            LOG.info("New Event Cloud for topic " + topic.getNamespaceURI() + topic.getLocalPart() + " created");
        }
    }

    private void sendNotify(EJaxbNotify notify, String address) {
        try {
            SOAPSender soapSender = new SOAPSender();
            Document soapRequest = SOAPSender.createSOAPMessageRequest((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notify));
            Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/notify");
            if (soapResponse != null && SOAPHandler.isSoapFault((Document)soapResponse)) {
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild(doc.importNode((Node)SOAPHandler.getFaultDetails((Document)soapResponse).get(0), true).cloneNode(true));
                SOAPException fault = (SOAPException)SOAJAXBContext.getInstance().marshallAnyType(doc, SOAPException.class);
                System.err.println("\n\nError message: \n" + fault.getMessage());
                System.err.println("Stack trace: \n" + fault.getStackTrace());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribeRequest) throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
        return null;
    }

    public EJaxbGetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws ResourceUnavailableFault, ResourceUnknownFault, InvalidResourcePropertyQNameFault {
        return null;
    }
}

