/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsrfbf.services.faults;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.abstraction.BaseFaultType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.refinedabstraction.RefinedWsrfbfFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.utils.WsrfbfException;
import java.util.Date;
import java.util.Locale;
import org.w3c.dom.Document;

public abstract class AbsWSStarFault
extends Exception {
    private static final long serialVersionUID = 1L;
    protected BaseFaultType wsnFault;

    public AbsWSStarFault() throws WsrfbfException {
        try {
            this.wsnFault = RefinedWsrfbfFactory.getInstance().createBaseFaultType(new Date());
        }
        catch (WsrfbfException e) {
            throw new WsrfbfException((Throwable)e);
        }
    }

    public AbsWSStarFault(Document faultAsDocument) throws WsrfbfException {
        try {
            this.wsnFault = RefinedWsrfbfFactory.getInstance().getWsrfbfReader().readBaseFaultType(faultAsDocument);
            this.init();
        }
        catch (WsrfbfException e) {
            throw new WsrfbfException((Throwable)e);
        }
    }

    public AbsWSStarFault(BaseFaultType fault) {
        this.wsnFault = fault;
    }

    protected final void init() throws WsrfbfException {
        this.wsnFault.setTimestamp(new Date());
    }

    protected final void init(Locale lang, String descContent) throws WsrfbfException {
        BaseFaultType.Description description;
        try {
            description = RefinedWsrfbfFactory.getInstance().createBaseFaultTypeDescription(null);
        }
        catch (WsrfbfException e) {
            throw new WsrfbfException((Throwable)e);
        }
        description.setLang(lang);
        description.setValue(descContent);
        if (this.wsnFault.getTimestamp() == null) {
            this.init();
        }
    }

    public final void setWsnFault(BaseFaultType wsnFault) {
        this.wsnFault = wsnFault;
    }

    public final BaseFaultType getWsnFault() {
        return this.wsnFault;
    }

    public abstract Document getDocumentFragment() throws Exception;
}

