package com.ebmwebsourcing.wsstar.wsnb.services.impl.util;

import java.net.URI;
import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsn.t_1_extension.EJaxbMessagesListType;
import com.ebmwebsourcing.wsn.t_1_extension.ObjectFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.MessageContentExpression;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType.Message;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.MessageContentExpressionImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.TopicExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbFilterType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbQueryExpressionType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbTopicExpressionType;

public class WSNHelper {

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}


	public static Subscribe createSubscription(String consumerAddress, QName topicUsed, QName... messages)
			throws WsnbException, SOAException {
		EndpointReferenceType epr = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
		Address value =  SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
		value.setValue(URI.create(consumerAddress));
		epr.setAddress(value);
		com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe payload = RefinedWsnbFactory.getInstance(new WsnbModelFactoryImpl()).createSubscribe(epr); 

		com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType notifyTopicExpr = createSimpleTopicExpression(topicUsed, URI.create("http://www.w3.org/TR/1999/REC-xpath-19991116").toString());

		com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.FilterType filter = RefinedWsnbFactory.getInstance().createFilterType();

		if(messages != null && messages.length > 0) {
			MessageContentExpression msgContentExpression = RefinedWsnbFactory.getInstance(new WsnbModelFactoryImpl()).createMessageContentExpression(URI.create("http://www.w3.org/TR/1999/REC-xpath-19991116"));
			EJaxbMessagesListType msgList = new EJaxbMessagesListType();
			for(QName msg: messages) {
				msgList.getMessage().add(msg);
			}
			msgContentExpression.setContent(msgList);
			filter.addMessageContentExpression(msgContentExpression);
		}

		filter.addTopicExpression(notifyTopicExpr);
		payload.setFilter(filter);

		Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload);
		EJaxbSubscribe subscribe = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbSubscribe.class);

		return payload;
	}

	public static EJaxbSubscribe marshallSubscribe(Document doc) throws WsnbException {
		Subscribe subscribe = Wsnb4ServUtils.getWsnbReader().readSubscribe(doc);
		return convert2JaxbElement(subscribe);
	}

	public static EJaxbSubscribe convert2JaxbElement(Subscribe subscribe) throws WsnbException {
		EJaxbSubscribe res = null;
		Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(subscribe);

		try {
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbSubscribe.class);
		} catch (SOAException e) {
			throw new WsnbException(e);
		}
		return res;
	}


	public static com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify createNotification(String consumerAddress, String producerAddress, QName topicUsed, Object payload)
			throws WsnbException, SOAException {
		com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify notifyPayload = null;

		Message mess = null;
		if(payload != null) {
			if(payload instanceof Document) {
				mess = RefinedWsnbFactory.getInstance()
						.createNotificationMessageHolderTypeMessage(((Document)payload).getDocumentElement());
			} else {
				mess = RefinedWsnbFactory.getInstance()
						.createNotificationMessageHolderTypeMessage(SOAJAXBContext.getInstance().unmarshallAnyElement(payload).getDocumentElement());
			}
		} else {
			mess = RefinedWsnbFactory.getInstance()
					.createNotificationMessageHolderTypeMessage(null);
		}
		NotificationMessageHolderType msg = RefinedWsnbFactory
				.getInstance().createNotificationMessageHolderType(mess);
		notifyPayload = RefinedWsnbFactory.getInstance().createNotify(msg);

		if(topicUsed != null) {
			final com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType notifyTopicExpr = createSimpleTopicExpression(topicUsed, "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
			msg.setTopic(notifyTopicExpr);
		}

		if(consumerAddress != null) {
			final EndpointReferenceType registrationRef = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
			Address address = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
			address.setValue(URI.create(consumerAddress));
			registrationRef.setAddress(address);

			final ReferenceParameters ref = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(ReferenceParameters.class);
			registrationRef.setReferenceParameters(ref);

			msg.setSubscriptionReference(registrationRef);
		}
		final EndpointReferenceType producerRef = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
		Address address = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
		address.setValue(URI.create(producerAddress));
		producerRef.setAddress(address);
		msg.setProducerReference(producerRef);

		return notifyPayload;
	}

	public static com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType createSimpleTopicExpression(QName topicUsed, String dialect) throws WsnbException {
		com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType notifyTopicExpr =  null;

		notifyTopicExpr = RefinedWsnbFactory.getInstance(new WsnbModelFactoryImpl()).createTopicExpressionType(URI.create(dialect));

		if(topicUsed.getPrefix() == null) {
			throw new WsnbException("prefix of topicUsed cannot be null");
		}

		ObjectFactory factory = new ObjectFactory(); 

		notifyTopicExpr.setContent(factory.createSimpleTopicExpression(topicUsed));

		return notifyTopicExpr;
	}


	public static EJaxbNotify marshallNotify(Document doc) throws WsnbException {
		com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify notify = Wsnb4ServUtils.getWsnbReader().readNotify(doc);
		return convert2JaxbElement(notify);
	}

	public static EJaxbNotify convert2JaxbElement(com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify notify) throws WsnbException {
		EJaxbNotify res = null;
		Document doc = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);

		try {
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbNotify.class);
		} catch (SOAException e) {
			throw new WsnbException(e);
		}

		return res;
	}


	public static QName getQNameInSimpleTopicExpression(TopicExpressionType topicItem) throws WsnbException {
		QName currentTopic = null;
		if(topicItem.getContent() instanceof JAXBElement) {
			// handle simpleTopicExpression
			JAXBElement elmt = (JAXBElement) topicItem.getContent();
			if(elmt.getValue() instanceof QName) {
				currentTopic = (QName) elmt.getValue();
			}  else {
				throw new WsnbException("TopicExpression type unknown");
			}
		} else if(topicItem.getContent() instanceof Element) {
			Element elmt = (Element)topicItem.getContent();
			String value = ((Text)elmt.getFirstChild()).getTextContent();

			if(value.indexOf(":") > 0 && value.trim().split(":").length > 0) {
				String prefix = value.trim().split(":")[0];
				String localpart = value.trim().split(":")[1];
				String xmlns = elmt.getAttribute("xmlns:" + prefix);
				currentTopic = new QName(xmlns, localpart, prefix);
			} else if(elmt.getAttribute("xmlns") != null) {
				String xmlns = elmt.getAttribute("xmlns");
				currentTopic = new QName(xmlns, value.trim());
			} else {
				currentTopic = new QName(value.trim());
			}


			System.out.println("currentTopic = " + currentTopic);
		} else {
			throw new WsnbException("TopicExpression type not supported here");
		}

		return currentTopic;
	}

	public static MessageContentExpression getMessageContentInFilter(EJaxbFilterType filter) {
		if(filter != null) {
			for (final Object item : filter.getAny()) {

				if (item instanceof JAXBElement<?> && 
						(((JAXBElement<?>) item).getValue() instanceof 
								EJaxbQueryExpressionType) &&
								((JAXBElement<?>)item).getName().equals(WsnbConstants.MESSAGE_CONTENT_QNAME)) {

					return new MessageContentExpressionImpl(
							(EJaxbQueryExpressionType)((JAXBElement<?>) item).getValue());

				}						
			}
		}
		return null;
	}

	public static List<QName> getMessages(MessageContentExpression messageContent) throws WsnbException {
		try {
			if(messageContent != null) {
				if(messageContent.getContent() instanceof EJaxbMessagesListType) {
					EJaxbMessagesListType msgs = (EJaxbMessagesListType) messageContent.getContent();
					return msgs.getMessage();
				} else if(messageContent.getContent() instanceof Element) {
					Element elmt = (Element) messageContent.getContent();
					Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder()
							.newDocument();
					doc.appendChild(doc.adoptNode(elmt));
					EJaxbMessagesListType msgs;
					msgs = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbMessagesListType.class);
					return msgs.getMessage();
				}
			}
		} catch (Exception e) {
			throw new WsnbException(e);
		} 
		return null;
	}

	public static TopicExpressionType getTopicExpressionInFilter(EJaxbFilterType filter) {
		for(Object item: filter.getAny()) {
			if (item instanceof JAXBElement<?> && ((JAXBElement<?>) item).getValue() instanceof
					EJaxbTopicExpressionType) {

				EJaxbTopicExpressionType jaxbObj =	
						(EJaxbTopicExpressionType)((JAXBElement<?>) item).getValue();

				return new TopicExpressionTypeImpl(jaxbObj);
			} else if(item instanceof EJaxbTopicExpressionType) {
				return new TopicExpressionTypeImpl((EJaxbTopicExpressionType)item);
			}
		}
		return null;
	}

	public static QName getQNameInSimpleTopicExpression(EJaxbTopicExpressionType topicItem) throws WsnbException {
		QName currentTopic = null;
		Object content = getObjectInList((List)topicItem.getContent());
		System.out.println("%%%%%%%%%%%%%%% content = " + content);
		if(content instanceof Element) {
			Element elmt = (Element)content;
			String value = ((Text)elmt.getFirstChild()).getTextContent();

			if(value.indexOf(":") > 0 && value.trim().split(":").length > 0) {
				String prefix = value.trim().split(":")[0];
				String localpart = value.trim().split(":")[1];
				String xmlns = elmt.getAttribute("xmlns:" + prefix);
				currentTopic = new QName(xmlns, localpart, prefix);
			} else if(elmt.getAttribute("xmlns") != null) {
				String xmlns = elmt.getAttribute("xmlns");
				currentTopic = new QName(xmlns, value.trim());
			} else {
				currentTopic = new QName(value.trim());
			}


			System.out.println("currentTopic = " + currentTopic);
		} else if(content instanceof JAXBElement) {
			JAXBElement jelmt = (JAXBElement) content;
			System.out.println(("%%%%%% value = " + jelmt.getValue()));
			if(jelmt.getValue() instanceof QName) {
				currentTopic = (QName) jelmt.getValue();
			}
		} else {
			throw new WsnbException("TopicExpression type not supported here");
		}

		return currentTopic;
	}
	
	private static Object getObjectInList(List<?> list) {
		System.out.println("%%%%%%%%%% list = " + list);
		for(Object obj: list) {
			if(obj != null && (!(obj instanceof String))) {
				return obj;
			}
		}
		return null;
	}


}
