/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.util;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsn.t_1_extension.EJaxbMessagesListType;
import com.ebmwebsourcing.wsn.t_1_extension.ObjectFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.FilterType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.MessageContentExpression;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.MessageContentExpressionImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.TopicExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbFilterType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbQueryExpressionType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbTopicExpressionType;
import java.net.URI;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WSNHelper {
    public static Subscribe createSubscription(String consumerAddress, QName topicUsed, QName ... messages) throws WsnbException, SOAException {
        EndpointReferenceType epr = (EndpointReferenceType)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
        Address value = (Address)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
        value.setValue(URI.create(consumerAddress));
        epr.setAddress(value);
        Subscribe payload = RefinedWsnbFactory.getInstance((WsnbModelFactory)new WsnbModelFactoryImpl()).createSubscribe(epr);
        TopicExpressionType notifyTopicExpr = WSNHelper.createSimpleTopicExpression(topicUsed, URI.create("http://www.w3.org/TR/1999/REC-xpath-19991116").toString());
        FilterType filter = RefinedWsnbFactory.getInstance().createFilterType();
        if (messages != null && messages.length > 0) {
            MessageContentExpression msgContentExpression = RefinedWsnbFactory.getInstance((WsnbModelFactory)new WsnbModelFactoryImpl()).createMessageContentExpression(URI.create("http://www.w3.org/TR/1999/REC-xpath-19991116"));
            EJaxbMessagesListType msgList = new EJaxbMessagesListType();
            for (QName msg : messages) {
                msgList.getMessage().add(msg);
            }
            msgContentExpression.setContent((Object)msgList);
            filter.addMessageContentExpression(msgContentExpression);
        }
        filter.addTopicExpression(notifyTopicExpr);
        payload.setFilter(filter);
        Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload);
        EJaxbSubscribe subscribe = (EJaxbSubscribe)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbSubscribe.class);
        return payload;
    }

    public static EJaxbSubscribe marshallSubscribe(Document doc) throws WsnbException {
        Subscribe subscribe = Wsnb4ServUtils.getWsnbReader().readSubscribe(doc);
        return WSNHelper.convert2JaxbElement(subscribe);
    }

    public static EJaxbSubscribe convert2JaxbElement(Subscribe subscribe) throws WsnbException {
        EJaxbSubscribe res = null;
        Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(subscribe);
        try {
            res = (EJaxbSubscribe)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbSubscribe.class);
        }
        catch (SOAException e) {
            throw new WsnbException((Throwable)e);
        }
        return res;
    }

    public static Notify createNotification(String consumerAddress, String producerAddress, QName topicUsed, Object payload) throws WsnbException, SOAException {
        Address address;
        Notify notifyPayload = null;
        NotificationMessageHolderType.Message mess = null;
        mess = payload != null ? (payload instanceof Document ? RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(((Document)payload).getDocumentElement()) : RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(SOAJAXBContext.getInstance().unmarshallAnyElement(payload).getDocumentElement())) : RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(null);
        NotificationMessageHolderType msg = RefinedWsnbFactory.getInstance().createNotificationMessageHolderType(mess);
        notifyPayload = RefinedWsnbFactory.getInstance().createNotify(msg);
        if (topicUsed != null) {
            TopicExpressionType notifyTopicExpr = WSNHelper.createSimpleTopicExpression(topicUsed, "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
            msg.setTopic(notifyTopicExpr);
        }
        if (consumerAddress != null) {
            EndpointReferenceType registrationRef = (EndpointReferenceType)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
            address = (Address)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
            address.setValue(URI.create(consumerAddress));
            registrationRef.setAddress(address);
            ReferenceParameters ref = (ReferenceParameters)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(ReferenceParameters.class);
            registrationRef.setReferenceParameters(ref);
            msg.setSubscriptionReference(registrationRef);
        }
        EndpointReferenceType producerRef = (EndpointReferenceType)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
        address = (Address)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
        address.setValue(URI.create(producerAddress));
        producerRef.setAddress(address);
        msg.setProducerReference(producerRef);
        return notifyPayload;
    }

    public static TopicExpressionType createSimpleTopicExpression(QName topicUsed, String dialect) throws WsnbException {
        TopicExpressionType notifyTopicExpr = null;
        notifyTopicExpr = RefinedWsnbFactory.getInstance((WsnbModelFactory)new WsnbModelFactoryImpl()).createTopicExpressionType(URI.create(dialect));
        if (topicUsed.getPrefix() == null) {
            throw new WsnbException("prefix of topicUsed cannot be null");
        }
        ObjectFactory factory = new ObjectFactory();
        notifyTopicExpr.setContent((Object)factory.createSimpleTopicExpression(topicUsed));
        return notifyTopicExpr;
    }

    public static EJaxbNotify marshallNotify(Document doc) throws WsnbException {
        Notify notify = Wsnb4ServUtils.getWsnbReader().readNotify(doc);
        return WSNHelper.convert2JaxbElement(notify);
    }

    public static EJaxbNotify convert2JaxbElement(Notify notify) throws WsnbException {
        EJaxbNotify res = null;
        Document doc = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
        try {
            res = (EJaxbNotify)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbNotify.class);
        }
        catch (SOAException e) {
            throw new WsnbException((Throwable)e);
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QName getQNameInSimpleTopicExpression(TopicExpressionType topicItem) throws WsnbException {
        QName currentTopic = null;
        if (topicItem.getContent() instanceof JAXBElement) {
            JAXBElement elmt = (JAXBElement)topicItem.getContent();
            if (!(elmt.getValue() instanceof QName)) throw new WsnbException("TopicExpression type unknown");
            return (QName)elmt.getValue();
        }
        if (!(topicItem.getContent() instanceof Element)) throw new WsnbException("TopicExpression type not supported here");
        Element elmt = (Element)topicItem.getContent();
        String value = ((Text)elmt.getFirstChild()).getTextContent();
        if (value.indexOf(":") > 0 && value.trim().split(":").length > 0) {
            String prefix = value.trim().split(":")[0];
            String localpart = value.trim().split(":")[1];
            String xmlns = elmt.getAttribute("xmlns:" + prefix);
            currentTopic = new QName(xmlns, localpart, prefix);
        } else if (elmt.getAttribute("xmlns") != null) {
            String xmlns = elmt.getAttribute("xmlns");
            currentTopic = new QName(xmlns, value.trim());
        } else {
            currentTopic = new QName(value.trim());
        }
        System.out.println("currentTopic = " + currentTopic);
        return currentTopic;
    }

    public static MessageContentExpression getMessageContentInFilter(EJaxbFilterType filter) {
        if (filter != null) {
            for (Object item : filter.getAny()) {
                if (!(item instanceof JAXBElement) || !(((JAXBElement)item).getValue() instanceof EJaxbQueryExpressionType) || !((JAXBElement)item).getName().equals(WsnbConstants.MESSAGE_CONTENT_QNAME)) continue;
                return new MessageContentExpressionImpl((EJaxbQueryExpressionType)((JAXBElement)item).getValue());
            }
        }
        return null;
    }

    public static List<QName> getMessages(MessageContentExpression messageContent) throws WsnbException {
        try {
            if (messageContent != null) {
                if (messageContent.getContent() instanceof EJaxbMessagesListType) {
                    EJaxbMessagesListType msgs = (EJaxbMessagesListType)messageContent.getContent();
                    return msgs.getMessage();
                }
                if (messageContent.getContent() instanceof Element) {
                    Element elmt = (Element)messageContent.getContent();
                    Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    doc.appendChild(doc.adoptNode(elmt));
                    EJaxbMessagesListType msgs = (EJaxbMessagesListType)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbMessagesListType.class);
                    return msgs.getMessage();
                }
            }
        }
        catch (Exception e) {
            throw new WsnbException((Throwable)e);
        }
        return null;
    }

    public static TopicExpressionType getTopicExpressionInFilter(EJaxbFilterType filter) {
        for (Object item : filter.getAny()) {
            if (item instanceof JAXBElement && ((JAXBElement)item).getValue() instanceof EJaxbTopicExpressionType) {
                EJaxbTopicExpressionType jaxbObj = (EJaxbTopicExpressionType)((JAXBElement)item).getValue();
                return new TopicExpressionTypeImpl(jaxbObj);
            }
            if (!(item instanceof EJaxbTopicExpressionType)) continue;
            return new TopicExpressionTypeImpl((EJaxbTopicExpressionType)item);
        }
        return null;
    }

    public static QName getQNameInSimpleTopicExpression(EJaxbTopicExpressionType topicItem) throws WsnbException {
        QName currentTopic = null;
        Object content = WSNHelper.getObjectInList(topicItem.getContent());
        System.out.println("%%%%%%%%%%%%%%% content = " + content);
        if (content instanceof Element) {
            Element elmt = (Element)content;
            String value = ((Text)elmt.getFirstChild()).getTextContent();
            if (value.indexOf(":") > 0 && value.trim().split(":").length > 0) {
                String prefix = value.trim().split(":")[0];
                String localpart = value.trim().split(":")[1];
                String xmlns = elmt.getAttribute("xmlns:" + prefix);
                currentTopic = new QName(xmlns, localpart, prefix);
            } else if (elmt.getAttribute("xmlns") != null) {
                String xmlns = elmt.getAttribute("xmlns");
                currentTopic = new QName(xmlns, value.trim());
            } else {
                currentTopic = new QName(value.trim());
            }
            System.out.println("currentTopic = " + currentTopic);
        } else if (content instanceof JAXBElement) {
            JAXBElement jelmt = (JAXBElement)content;
            System.out.println("%%%%%% value = " + jelmt.getValue());
            if (jelmt.getValue() instanceof QName) {
                currentTopic = (QName)jelmt.getValue();
            }
        } else {
            throw new WsnbException("TopicExpression type not supported here");
        }
        return currentTopic;
    }

    private static Object getObjectInList(List<?> list) {
        System.out.println("%%%%%%%%%% list = " + list);
        for (Object obj : list) {
            if (obj == null || obj instanceof String) continue;
            return obj;
        }
        return null;
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

