/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easierbsm.datacollector.ESBDataCollectorFactoryImpl;
import com.ebmwebsourcing.easierbsm.sla.manager.ESBSLAManagerFactoryImpl;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLAManagerComponent;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLAManagerComponentBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.ESBWSDMFactoryImpl;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngineBehaviour;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.BSMAdminExtensionFactory;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour.BSMAdminEndpointBehaviourImpl;

import easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg;

public class BSMFactoryImpl extends ESBFactoryImpl implements
ESBFactory {

	private static Logger log = Logger
			.getLogger(BSMFactoryImpl.class.getName());


	@Override
	public Node createNode(QName name,
			Configuration conf) throws ESBException {

		final Node node = super.createDefaultNode(name, conf);

		ESBDataCollectorFactoryImpl.createDataCollector(node, this, conf);
		ESBWSDMFactoryImpl.createWSDMMonitoring(node, this, conf);
		ESBSLAManagerFactoryImpl.createSLAManager(node, this);

		try {
			// connect wsdm manager to data collector
			WSDMMonitoringEngine wsdmMonitoringEngine = (WSDMMonitoringEngine) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getComponent(ESBWSDMFactoryImpl.WSDM_MONITORING_COMPONENT_NAME);
			((WSDMMonitoringEngineBehaviour)wsdmMonitoringEngine.findBehaviour(WSDMMonitoringEngineBehaviour.class)).connectToDataCollector();

			// connect sla manager to data collector
			SLAManagerComponent slaManagerComponent = (SLAManagerComponent) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getComponent(new QName(ESBSLAManagerFactoryImpl.SLA_NAMESPACE, ESBSLAManagerFactoryImpl.SLA_MANAGER_COMPONENT_NAME));
			((SLAManagerComponentBehaviour)slaManagerComponent.findBehaviour(SLAManagerComponentBehaviour.class)).connectToDataCollector();


			BSMAdminExtensionFactory bsmAdmin = new BSMAdminExtensionFactory();
			bsmAdmin.addSpecificElements(name, node, conf);
			bsmAdmin.exposeBSMAdminService(node);
		} catch (AdminExceptionMsg e) {
			throw new ESBException(e);
		} catch (easierbsm.petalslink.com.service.slamanager._1_0.AdminExceptionMsg e) {
			throw new ESBException(e);
		}

		return node;
	}

}
